/*
 * Decompiled with CFR 0.152.
 */
package org.voidland.m2e;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="eclipse-settings", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.NONE)
public class EclipseSettingsComplementor
extends AbstractMojo {
    private static final String SETTINGS_DIRECTORY_IN_PROJECT = ".settings";
    private static final String SETTINGS_DIRECTORY_IN_JAR = "settings";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    private PluginDescriptor plugin;
    @Parameter
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        try {
            Set<Artifact> artifacts = this.collectArtifacts();
            this.processArtifacts(artifacts);
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private Set<Artifact> collectArtifacts() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        PluginManagement pluginManagement = this.project.getBuild().getPluginManagement();
        if (pluginManagement != null) {
            artifacts.addAll(this.getDependenciesAsArtifacts(pluginManagement.getPluginsAsMap()));
        }
        artifacts.addAll(this.getDependenciesAsArtifacts(this.project.getBuild().getPluginsAsMap()));
        return artifacts;
    }

    private Set<Artifact> getDependenciesAsArtifacts(Map<String, Plugin> plugins) {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Plugin thisPlugin = plugins.get(this.getThisPluginKey());
        if (thisPlugin != null) {
            for (Dependency dependency : thisPlugin.getDependencies()) {
                String dependencyKey = dependency.getGroupId() + ":" + dependency.getArtifactId();
                Artifact dependencyArtifact = (Artifact)this.plugin.getArtifactMap().get(dependencyKey);
                if (dependencyArtifact == null) continue;
                artifacts.add(dependencyArtifact);
            }
        }
        return artifacts;
    }

    private String getThisPluginKey() {
        return this.plugin.getGroupId() + ":" + this.plugin.getArtifactId();
    }

    private void processArtifacts(Set<Artifact> artifacts) throws IOException {
        for (Artifact artifact : artifacts) {
            this.processJarFile(artifact.getFile());
        }
    }

    private void processJarFile(File jarFile) throws IOException {
        String pathPrefix = "settings/";
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                String fileName;
                String jarEntryPath;
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory() || !(jarEntryPath = jarEntry.getName()).startsWith(pathPrefix) || (fileName = jarEntryPath.substring(pathPrefix.length())).indexOf(47) >= 0) continue;
                InputStream jarEntryInputStream = jar.getInputStream(jarEntry);
                try {
                    this.processSettingsFile(fileName, jarEntryInputStream);
                }
                finally {
                    if (jarEntryInputStream == null) continue;
                    jarEntryInputStream.close();
                }
            }
        }
    }

    private void processSettingsFile(String fileName, InputStream inputStream) throws IOException {
        Path targetPath = Paths.get(this.project.getBasedir().getPath(), SETTINGS_DIRECTORY_IN_PROJECT, fileName);
        Properties settings = new Properties();
        try (FileInputStream targetInputStream2 = new FileInputStream(targetPath.toFile());){
            settings.load(targetInputStream2);
        }
        catch (FileNotFoundException targetInputStream2) {
            // empty catch block
        }
        Properties complementarySettings = new Properties();
        complementarySettings.load(inputStream);
        settings.putAll((Map<?, ?>)complementarySettings);
        try (FileOutputStream targetOutputStream = new FileOutputStream(targetPath.toFile());){
            settings.store(targetOutputStream, null);
        }
    }
}

