/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import java.util.Collection;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.vootoo.RequestGetter;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.client.netty.util.ProtobufUtil;

public class ProtobufRequestGetter
implements RequestGetter {
    private final SolrProtocol.SolrRequest protocolSolrRequest;
    private long receiveTime;
    private SolrParams solrParams;
    private Collection<ContentStream> contentStreams;

    public ProtobufRequestGetter(SolrProtocol.SolrRequest protocolSolrRequest) {
        this.protocolSolrRequest = protocolSolrRequest;
        this.receiveTime = System.currentTimeMillis();
    }

    @Override
    public SolrParams getSolrParams() {
        if (this.solrParams == null) {
            this.solrParams = ProtobufUtil.toSolrParams(this.protocolSolrRequest);
        }
        return this.solrParams;
    }

    @Override
    public Collection<ContentStream> getContentStreams() {
        if (this.contentStreams == null) {
            this.contentStreams = ProtobufUtil.toSolrContentStreams(this.protocolSolrRequest);
        }
        return this.contentStreams;
    }

    @Override
    public String getCollection() {
        String col = this.protocolSolrRequest.getCollection();
        return col == null ? "" : col;
    }

    @Override
    public String getPath() {
        return this.protocolSolrRequest.getPath();
    }

    public long getRid() {
        return this.protocolSolrRequest.getRid();
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public boolean isTimeout(int expectTimeout) {
        return this.useTime() > (long)expectTimeout;
    }

    public long useTime() {
        return System.currentTimeMillis() - this.receiveTime;
    }

    @Override
    public int requestSize() {
        return this.protocolSolrRequest.getSerializedSize();
    }

    @Override
    public String getMethod() {
        return this.protocolSolrRequest.getMethod();
    }
}

