/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import java.util.Collection;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.client.netty.util.ProtobufUtil;

public class ProtobufRequestSetter {
    private SolrProtocol.SolrRequest.Builder solrRequestBuilder = SolrProtocol.SolrRequest.newBuilder();
    private SolrParams solrParams;
    private int timeout;
    private SolrRequest.METHOD method = SolrRequest.METHOD.GET;

    public ProtobufRequestSetter setCollection(String collection) {
        this.solrRequestBuilder.setCollection(collection);
        return this;
    }

    public ProtobufRequestSetter setRid(long rid) {
        this.solrRequestBuilder.setRid(rid);
        return this;
    }

    public ProtobufRequestSetter setPath(String path) {
        this.solrRequestBuilder.setPath(path);
        return this;
    }

    public ProtobufRequestSetter setSolrParams(SolrParams solrParams) {
        this.solrParams = solrParams;
        this.solrRequestBuilder.addAllParam(ProtobufUtil.toProtobufParams(solrParams));
        return this;
    }

    public ProtobufRequestSetter setContentStreams(Collection<ContentStream> contentStreams) {
        this.solrRequestBuilder.addAllContentStream(ProtobufUtil.toProtobufContentStreams(contentStreams));
        return this;
    }

    public ProtobufRequestSetter setMethod(SolrRequest.METHOD method) {
        this.method = method;
        this.solrRequestBuilder.setMethod(this.method.name());
        return this;
    }

    public SolrProtocol.SolrRequest buildProtocolRequest() {
        return this.solrRequestBuilder.build();
    }

    public SolrParams getSolrParams() {
        return this.solrParams;
    }

    public long getRid() {
        return this.solrRequestBuilder.getRid();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

