/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import io.netty.util.concurrent.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.client.netty.protocol.SolrProtocol;

public class ResponsePromise {
    private static final Logger logger = LoggerFactory.getLogger(ResponsePromise.class);
    private long rid;
    private Promise<SolrProtocol.SolrResponse> responsePromise;

    public ResponsePromise(long rid) {
        this.rid = rid;
    }

    public void setResponsePromise(Promise<SolrProtocol.SolrResponse> responsePromise) {
        this.responsePromise = responsePromise;
    }

    public long getRid() {
        return this.rid;
    }

    void setRid(long rid) {
        this.rid = rid;
    }

    public void receiveResponse(SolrProtocol.SolrResponse solrResponse) {
        assert (this.responsePromise != null);
        this.responsePromise.setSuccess((Object)solrResponse);
    }

    public void setFailure(Throwable cause) {
        this.responsePromise.setFailure(cause);
    }

    public SolrProtocol.SolrResponse waitResult(long timeout) {
        assert (this.responsePromise != null);
        this.responsePromise.awaitUninterruptibly(timeout);
        if (this.responsePromise.isDone()) {
            if (this.responsePromise.isSuccess()) {
                return (SolrProtocol.SolrResponse)this.responsePromise.getNow();
            }
            logger.warn("rid=[" + this.rid + "] response not success", this.responsePromise.cause());
        }
        return null;
    }
}

