/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.vootoo.client.netty;

/**
 * @author chenlb on 2015-06-13 16:31.
 */
public class HandlerConfig {

  public static final HandlerConfig DEFAULT_CONFIG = new HandlerConfig(ResponsePromiseContainer.GLOBAL_CONTAINER);

  private ResponsePromiseContainer responsePromiseContainer;
  private int maxFrameLengthMB = 200;

  public HandlerConfig(ResponsePromiseContainer responsePromiseContainer) {
    this.responsePromiseContainer = responsePromiseContainer;
  }

  public ResponsePromiseContainer getResponsePromiseContainer() {
    return responsePromiseContainer;
  }

  public int getMaxFrameLengthMB() {
    return maxFrameLengthMB;
  }

  public void setMaxFrameLengthMB(int maxFrameLengthMB) {
    this.maxFrameLengthMB = maxFrameLengthMB;
  }
}
