/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.common;

import org.apache.solr.common.SolrException;

public class VootooException
extends SolrException {
    private String remoteServer;
    private String remoteTrace;
    private int unknownCode;

    public VootooException(SolrException.ErrorCode errorCode, String msg) {
        super(errorCode.code, msg, null);
    }

    public VootooException(VootooErrorCode errorCode, String msg) {
        super(errorCode.code, msg, null);
    }

    public VootooException(SolrException.ErrorCode errorCode, String msg, Throwable th) {
        super(errorCode.code, msg, th);
    }

    public VootooException(VootooErrorCode errorCode, Throwable th) {
        super(errorCode.code, null, th);
    }

    public VootooException(VootooErrorCode errorCode, String msg, Throwable th) {
        super(errorCode.code, msg, th);
    }

    public int getUnknownCode() {
        return this.unknownCode;
    }

    public void setUnknownCode(int unknownCode) {
        this.unknownCode = unknownCode;
    }

    public String getRemoteTrace() {
        return this.remoteTrace;
    }

    public void setRemoteTrace(String remoteTrace) {
        this.remoteTrace = remoteTrace;
    }

    public String getRemoteServer() {
        return this.remoteServer;
    }

    public void setRemoteServer(String remoteServer) {
        this.remoteServer = remoteServer;
    }

    public static enum VootooErrorCode {
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        CONFLICT(409),
        UNSUPPORTED_MEDIA_TYPE(415),
        SERVER_ERROR(500),
        SERVICE_UNAVAILABLE(503),
        INVALID_STATE(510),
        TIMEOUT(408),
        TOO_MANY_REQUESTS(429),
        UNKNOWN(0);

        public final int code;

        private VootooErrorCode(int c) {
            this.code = c;
        }

        public static VootooErrorCode getErrorCode(int c) {
            for (VootooErrorCode err : VootooErrorCode.values()) {
                if (err.code != c) continue;
                return err;
            }
            return UNKNOWN;
        }
    }
}

