/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.vootoo.client.netty.ResponsePromise;

public class ResponsePromiseContainer {
    public static final ResponsePromiseContainer GLOBAL_CONTAINER = new ResponsePromiseContainer();
    protected AtomicLong ridSeed = new AtomicLong(0L);
    protected ConcurrentMap<Long, ResponsePromise> responsePromiseMaps = PlatformDependent.newConcurrentHashMap();

    public ResponsePromise createResponsePromise() {
        ResponsePromise oldPromise;
        long rid = this.ridSeed.incrementAndGet();
        ResponsePromise responsePromise = new ResponsePromise(rid);
        while ((oldPromise = this.responsePromiseMaps.putIfAbsent(rid, responsePromise)) != null) {
            rid = this.ridSeed.incrementAndGet();
        }
        responsePromise.setRid(rid);
        return responsePromise;
    }

    public ResponsePromise removeResponsePromise(long rid) {
        return (ResponsePromise)this.responsePromiseMaps.remove(rid);
    }
}

