/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty.connect;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.client.netty.HandlerConfig;
import org.vootoo.client.netty.SolrClientChannelPoolHandler;
import org.vootoo.client.netty.connect.ConnectionPool;
import org.vootoo.client.netty.connect.ConnectionPoolContext;
import org.vootoo.client.netty.connect.NettyConnectLessException;

public class SimpleConnectionPool
extends SimpleChannelPool
implements ConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(SimpleConnectionPool.class);
    protected static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    protected final SocketAddress socketAddress;
    protected final String host;
    protected final int port;
    protected int connectTimeout;
    protected ConnectionPoolContext poolContext;

    public SimpleConnectionPool(Bootstrap bootstrap, SocketAddress remoteAddress) {
        this(bootstrap, HandlerConfig.DEFAULT_CONFIG, remoteAddress, 2000);
    }

    public SimpleConnectionPool(Bootstrap bootstrap, HandlerConfig handlerConfig, SocketAddress remoteAddress) {
        this(bootstrap, handlerConfig, remoteAddress, 2000);
    }

    public SimpleConnectionPool(Bootstrap bootstrap, HandlerConfig handlerConfig, SocketAddress remoteAddress, int connectTimeout) {
        super(bootstrap, (ChannelPoolHandler)new SolrClientChannelPoolHandler(handlerConfig, remoteAddress));
        this.connectTimeout = connectTimeout;
        this.socketAddress = remoteAddress;
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
            this.host = inetSocketAddress.getAddress().getHostAddress();
            this.port = inetSocketAddress.getPort();
        } else if (remoteAddress instanceof LocalAddress) {
            LocalAddress localAddress = (LocalAddress)remoteAddress;
            int myPort = -1;
            try {
                myPort = Integer.parseInt(localAddress.id());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.host = "local";
            this.port = myPort;
        } else {
            throw new IllegalArgumentException("SocketAddress must be '" + InetSocketAddress.class.getName() + "' or '" + LocalAddress.class.getName() + "' (sub) class");
        }
        this.poolContext = new ConnectionPoolContext(handlerConfig.getResponsePromiseContainer());
    }

    protected ChannelFuture connectChannel(Bootstrap bs) {
        bs.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
        return bs.connect(this.socketAddress);
    }

    @Override
    public Channel acquireConnect() throws NettyConnectLessException {
        Future future = this.acquire();
        future.awaitUninterruptibly();
        assert (future.isDone());
        if (future.isCancelled()) {
            throw new NettyConnectLessException("connection cancelled tcp=" + this.socketAddress);
        }
        if (!future.isSuccess()) {
            throw new NettyConnectLessException("connect tcp=" + this.socketAddress + " fail within " + this.connectTimeout + "ms time!", future.cause());
        }
        Channel channel = (Channel)future.getNow();
        if (logger.isDebugEnabled()) {
            logger.debug("acquire connect success channel={}", (Object)channel);
        }
        assert (channel != null);
        if (channel == null) {
            throw new NettyConnectLessException("connect tcp=" + this.socketAddress + " fail within " + this.connectTimeout + "ms time, future.getNow return null!");
        }
        return channel;
    }

    @Override
    public void releaseConnect(Channel channel) {
        Future future = this.release(channel);
    }

    @Override
    public ConnectionPoolContext poolContext() {
        return this.poolContext;
    }

    @Override
    public String channelHost() {
        return this.host;
    }

    @Override
    public int channelPort() {
        return this.port;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 10) {
            throw new IllegalArgumentException("connectTimeout can't < 10ms");
        }
        this.connectTimeout = connectTimeout;
    }
}

