/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.client.netty.ResponsePromise;
import org.vootoo.client.netty.ResponsePromiseContainer;
import org.vootoo.client.netty.protocol.SolrProtocol;

public class SolrClientHandler
extends SimpleChannelInboundHandler<SolrProtocol.SolrResponse> {
    private static final Logger logger = LoggerFactory.getLogger(SolrClientHandler.class);
    protected static final String CLIENT_HANDLER_NAME = "vootoo_solr_handler";
    protected final ResponsePromiseContainer responsePromiseContainer;

    public SolrClientHandler(ResponsePromiseContainer responsePromiseContainer) {
        if (responsePromiseContainer == null) {
            throw new IllegalArgumentException("ResponsePromise maps can't be null!");
        }
        this.responsePromiseContainer = responsePromiseContainer;
    }

    public static SolrClientHandler getSolrClientHandler(Channel channel) {
        SolrClientHandler clientHandler = (SolrClientHandler)channel.pipeline().get(CLIENT_HANDLER_NAME);
        assert (clientHandler != null);
        return clientHandler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, SolrProtocol.SolrResponse solrResponse) throws Exception {
        ResponsePromise responsePromise = this.responsePromiseContainer.removeResponsePromise(solrResponse.getRid());
        if (responsePromise != null) {
            logger.debug("receive response={}", (Object)solrResponse);
            responsePromise.receiveResponse(solrResponse);
        } else {
            SocketAddress remoteAddress = ctx.channel().remoteAddress();
            logger.warn("miss rid='{}' at {} receive response", (Object)solrResponse.getRid(), (Object)remoteAddress);
            responsePromise.setFailure(new IllegalStateException("receive not registered response, rid=" + solrResponse.getRid() + ", server=" + remoteAddress));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("Unexpected exception from downstream. close channel=" + ctx.channel(), cause);
        ctx.close();
    }

    private Promise<SolrProtocol.SolrResponse> newPromise(Channel channel) {
        return channel.eventLoop().next().newPromise();
    }

    public ChannelFuture writeRequest(Channel channel, SolrProtocol.SolrRequest solrRequest, ResponsePromise responsePromise) {
        responsePromise.setResponsePromise(this.newPromise(channel));
        ChannelFuture writeFuture = channel.writeAndFlush((Object)solrRequest);
        return writeFuture;
    }

    public void removeResponsePromise(long rid) {
        this.responsePromiseContainer.removeResponsePromise(rid);
    }
}

