/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.solr.schema.TrieDateField;

public abstract class CollectorFilterable {
    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public abstract boolean matches(int var1);

    public abstract void setNextReader(Map var1, AtomicReaderContext var2) throws IOException;

    public static List<Object> parseValue(String[] values, Parser parser) {
        ArrayList<Object> vs = new ArrayList<Object>(values.length);
        for (String value : values) {
            vs.add(parser.parse(value));
        }
        return vs;
    }

    public static List<Object> parseValue(String[] values, Object targetObject) {
        if (targetObject.getClass().isPrimitive()) {
            Class<?> clazz = targetObject.getClass();
            if (Byte.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new ByteParser());
            }
            if (Short.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new ShortParser());
            }
            if (Integer.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new IntParser());
            }
            if (Long.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new LongParser());
            }
            if (Double.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new DoubleParser());
            }
            if (Float.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new FloatParser());
            }
            if (Boolean.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new BoolParser());
            }
            if (Character.TYPE.isAssignableFrom(clazz)) {
                return CollectorFilterable.parseValue(values, new CharParser());
            }
            return CollectorFilterable.parseValue(values, new StringParser());
        }
        if (targetObject instanceof Number) {
            if (targetObject instanceof Integer) {
                return CollectorFilterable.parseValue(values, new IntParser());
            }
            if (targetObject instanceof Double) {
                return CollectorFilterable.parseValue(values, new DoubleParser());
            }
            if (targetObject instanceof Long) {
                return CollectorFilterable.parseValue(values, new LongParser());
            }
            if (targetObject instanceof Byte) {
                return CollectorFilterable.parseValue(values, new ByteParser());
            }
            if (targetObject instanceof Short) {
                return CollectorFilterable.parseValue(values, new ShortParser());
            }
            if (targetObject instanceof Float) {
                return CollectorFilterable.parseValue(values, new FloatParser());
            }
            return CollectorFilterable.parseValue(values, new DoubleParser());
        }
        if (targetObject instanceof String) {
            return CollectorFilterable.parseValue(values, new StringParser());
        }
        if (targetObject instanceof Boolean) {
            return CollectorFilterable.parseValue(values, new BoolParser());
        }
        if (targetObject instanceof Date) {
            return CollectorFilterable.parseValue(values, new DateParser());
        }
        if (targetObject instanceof Character) {
            return CollectorFilterable.parseValue(values, new CharParser());
        }
        return CollectorFilterable.parseValue(values, new StringParser());
    }

    public static class DateParser
    implements Parser {
        @Override
        public Object parse(String value) {
            try {
                return TrieDateField.parseDate((String)value);
            }
            catch (ParseException e) {
                throw new RuntimeException("value='" + value + "' parse date error", e);
            }
        }
    }

    public static class BoolParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Boolean.parseBoolean(value);
        }
    }

    public static class CharParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Character.valueOf(value.charAt(0));
        }
    }

    public static class StringParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return value;
        }
    }

    public static class DoubleParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Double.parseDouble(value);
        }
    }

    public static class FloatParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Float.valueOf(Float.parseFloat(value));
        }
    }

    public static class LongParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Long.parseLong(value);
        }
    }

    public static class IntParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Integer.parseInt(value);
        }
    }

    public static class ShortParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Short.parseShort(value);
        }
    }

    public static class ByteParser
    implements Parser {
        @Override
        public Object parse(String value) {
            return Byte.parseByte(value);
        }
    }

    public static interface Parser {
        public Object parse(String var1);
    }
}

