/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.apache.solr.search.SolrFilter;
import org.vootoo.search.CollectorFilterable;
import org.vootoo.search.ValueSourceCollectorFilterable;

public class ValueSourceCollectorFilter
extends SolrFilter {
    private final ValueSource valueSource;
    private final CollectorFilterable collectorFilterable;

    public ValueSourceCollectorFilter(ValueSource valueSource, CollectorFilterable collectorFilterable) {
        this.valueSource = valueSource;
        this.collectorFilterable = collectorFilterable;
    }

    public ValueSourceCollectorFilter(ValueSourceCollectorFilterable valueSourceCollectorFilterable) {
        this(valueSourceCollectorFilterable.getValueSource(), valueSourceCollectorFilterable);
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.valueSource.createWeight(context, searcher);
    }

    public DocIdSet getDocIdSet(final Map context, final AtomicReaderContext readerContext, Bits acceptDocs) throws IOException {
        this.collectorFilterable.setNextReader(context, readerContext);
        return BitsFilteredDocIdSet.wrap((DocIdSet)new DocIdSet(){

            public DocIdSetIterator iterator() throws IOException {
                return new ValueSourceScorer((IndexReader)readerContext.reader(), ValueSourceCollectorFilter.this.valueSource.getValues(context, readerContext)){

                    public boolean matchesValue(int doc) {
                        return ValueSourceCollectorFilter.this.collectorFilterable.matches(doc);
                    }
                };
            }

            public Bits bits() {
                return null;
            }
        }, (Bits)acceptDocs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("vsfilter(");
        sb.append(this.valueSource).append(",");
        sb.append(this.collectorFilterable.description());
        sb.append(")");
        return sb.toString();
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public CollectorFilterable getCollectorFilterable() {
        return this.collectorFilterable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collectorFilterable == null ? 0 : this.collectorFilterable.hashCode());
        result = 31 * result + (this.valueSource == null ? 0 : this.valueSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ValueSourceCollectorFilter other = (ValueSourceCollectorFilter)((Object)obj);
        if (this.collectorFilterable == null ? other.collectorFilterable != null : !this.collectorFilterable.equals(other.collectorFilterable)) {
            return false;
        }
        return !(this.valueSource == null ? other.valueSource != null : !this.valueSource.equals((Object)other.valueSource));
    }
}

