/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search.function.filter;

import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.vootoo.search.CollectorFilterable;
import org.vootoo.search.CollectorFilterablePlugin;
import org.vootoo.search.function.filter.RangeCollectorFilterable;

public class RangeCollectorFilterablePlugin
extends CollectorFilterablePlugin {
    public static final String NAME = "range";

    @Override
    public CollectorFilterable createCollectorFilterable(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, ValueSource valueSource, String valueStr) throws SyntaxError {
        ValueSourceRangeFilter rf = null;
        if (valueStr == null) {
            String l = localParams.get("l");
            String u = localParams.get("u");
            boolean includeLower = localParams.getBool("incl", true);
            boolean includeUpper = localParams.getBool("incu", true);
            rf = new ValueSourceRangeFilter(valueSource, l, u, includeLower, includeUpper);
        } else {
            this.verifyValueStr(valueStr, valueSource);
            rf = RangeCollectorFilterablePlugin.parseRange(valueSource, valueStr);
        }
        return new RangeCollectorFilterable(rf);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

