/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.schema;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;

public class CrossCoreField
extends FieldType
implements SchemaAware {
    private String CROSS_CORE_PREFIX = "_solr_";
    private IndexSchema schema;

    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        throw new UnsupportedOperationException();
    }

    private String[] dumpCrossSchemaField(SchemaField field) {
        String name = field.getName();
        assert (name.startsWith(this.CROSS_CORE_PREFIX));
        String subName = name.substring(this.CROSS_CORE_PREFIX.length());
        ArrayList names = Lists.newArrayList((Iterable)Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)subName));
        if (names.size() < 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, CrossCoreField.class.getSimpleName() + "'s field [" + field.getName() + "] must content '.' to split collection and target field");
        }
        String crossCoreName = (String)names.get(0);
        String crossFieldName = null;
        if (names.size() > 2) {
            names.remove(0);
            crossFieldName = Joiner.on((char)'.').join((Iterable)names);
        } else {
            crossFieldName = (String)names.get(1);
        }
        return new String[]{crossCoreName, crossFieldName};
    }

    public SortField getSortField(SchemaField field, boolean top) {
        throw new UnsupportedOperationException();
    }

    public ValueSource getValueSource(SchemaField field, QParser parser) {
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        if (info == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core field [" + field.getName() + "] must have SolrRequestInfo");
        }
        String[] crossCore = this.dumpCrossSchemaField(field);
        SchemaField uniqueKeyField = this.schema.getUniqueKeyField();
        final SolrCore targetCore = info.getReq().getCore().getCoreDescriptor().getCoreContainer().getCore(crossCore[0]);
        if (targetCore == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core field [" + field.getName() + "] miss target core [" + crossCore[0] + "]");
        }
        SchemaField targetField = targetCore.getLatestSchema().getFieldOrNull(crossCore[1]);
        if (targetField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core field [" + field.getName() + "] core [" + crossCore[0] + "] miss field [" + crossCore[1] + "]");
        }
        final RefCounted targetCoreSearcher = targetCore.getSearcher();
        SolrIndexSearcher targetSolrIndexSearcher = (SolrIndexSearcher)targetCoreSearcher.get();
        CrossCoreFieldValueSource ccfvs = new CrossCoreFieldValueSource(uniqueKeyField, targetField, parser, targetSolrIndexSearcher);
        info.addCloseHook(new Closeable(){

            @Override
            public void close() throws IOException {
                targetCoreSearcher.decref();
                targetCore.close();
            }
        });
        return ccfvs;
    }

    public void inform(IndexSchema schema) {
        this.schema = schema;
        for (IndexSchema.DynamicField df : schema.getDynamicFields()) {
            if (!(df.getPrototype().getType() instanceof CrossCoreField) || df.getPrototype().getName().startsWith(this.CROSS_CORE_PREFIX)) continue;
            throw new RuntimeException(CrossCoreField.class.getSimpleName() + "'s field define name need '" + this.CROSS_CORE_PREFIX + "' prefix");
        }
    }

    private static class CrossCoreFieldValueSource
    extends ValueSource {
        final ValueSource mainKeySource;
        SchemaField uniqueKeyField;
        final SolrIndexSearcher targetSolrIndexSearcher;
        SchemaField targetField;
        ValueSource targetValueSource;

        public CrossCoreFieldValueSource(SchemaField uniqueKeyField, SchemaField targetField, QParser parser, SolrIndexSearcher targetSolrIndexSearcher) {
            this.mainKeySource = uniqueKeyField.getType().getValueSource(uniqueKeyField, parser);
            this.targetValueSource = targetField.getType().getValueSource(targetField, parser);
            this.uniqueKeyField = uniqueKeyField;
            this.targetField = targetField;
            this.targetSolrIndexSearcher = targetSolrIndexSearcher;
        }

        private Object toDefaultObject() {
            SchemaField field = this.targetField;
            if (field.getDefaultValue() != null) {
                return field.getType().toObject(field.createField((Object)field.getDefaultValue(), 1.0f));
            }
            return null;
        }

        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            FunctionValues mainValues = this.mainKeySource.getValues(context, readerContext);
            FunctionValues targetValues = this.targetValueSource.getValues(context, this.targetSolrIndexSearcher.getLeafReader().getContext());
            return new CrossCoreFunctionValues(mainValues, targetValues);
        }

        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String description() {
            return "cross_core_field(" + this.targetSolrIndexSearcher.getCore().getName() + ", " + this.targetField.getName() + ")";
        }

        private class CrossCoreFunctionValues
        extends FunctionValues {
            final FunctionValues mainValues;
            final FunctionValues targetValues;
            Object defaultValue;

            public CrossCoreFunctionValues(FunctionValues mainValues, FunctionValues targetValues) {
                this.mainValues = mainValues;
                this.targetValues = targetValues;
                this.defaultValue = CrossCoreFieldValueSource.this.toDefaultObject();
            }

            public int targetDocId(int doc) {
                String mainKey = this.mainValues.strVal(doc);
                BytesRefBuilder brb = new BytesRefBuilder();
                CrossCoreFieldValueSource.this.uniqueKeyField.getType().readableToIndexed((CharSequence)mainKey, brb);
                try {
                    return CrossCoreFieldValueSource.this.targetSolrIndexSearcher.getFirstMatch(new Term(CrossCoreFieldValueSource.this.uniqueKeyField.getName(), brb.get()));
                }
                catch (IOException e) {
                    return -1;
                }
            }

            public byte byteVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return 0;
                }
                return this.targetValues.byteVal(tdid);
            }

            public short shortVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return 0;
                }
                return this.targetValues.shortVal(tdid);
            }

            public float floatVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return 0.0f;
                }
                return this.targetValues.floatVal(tdid);
            }

            public int intVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return 0;
                }
                return this.targetValues.intVal(tdid);
            }

            public long longVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return 0L;
                }
                return this.targetValues.longVal(tdid);
            }

            public double doubleVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return 0.0;
                }
                return this.targetValues.doubleVal(tdid);
            }

            public boolean boolVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return false;
                }
                return this.targetValues.boolVal(tdid);
            }

            public boolean exists(int doc) {
                return this.targetDocId(doc) >= 0;
            }

            public Object objectVal(int doc) {
                int tdid = this.targetDocId(doc);
                if (tdid < 0) {
                    return this.defaultValue;
                }
                return this.targetValues.objectVal(tdid);
            }

            public String toString(int doc) {
                return String.valueOf(this.objectVal(doc));
            }
        }
    }
}

