/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search;

import java.util.Map;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.vootoo.search.CollectorFilterQuery;
import org.vootoo.search.CollectorFilterable;
import org.vootoo.search.CollectorFilterablePlugin;
import org.vootoo.search.WrappedNotCollectorFilterable;
import org.vootoo.search.function.ValueSourceCollectorFilter;

public class CollectorFilterQParser
extends FunctionQParser {
    public static final String CF_NAME = "name";
    public static final String CF_NOT = "not";
    protected Map<String, CollectorFilterablePlugin> customPlugins = null;

    public CollectorFilterQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, Map<String, CollectorFilterablePlugin> customPlugins) {
        super(qstr, localParams, params, req);
        this.setParseMultipleSources(false);
        this.setParseToEnd(false);
        this.customPlugins = customPlugins;
    }

    public CollectorFilterablePlugin getCollectorFilterablePlugin(String name) {
        CollectorFilterablePlugin cfPlugin = CollectorFilterablePlugin.standardPlugins.get(name);
        if (cfPlugin == null && this.customPlugins != null) {
            cfPlugin = this.customPlugins.get(name);
        }
        return cfPlugin;
    }

    public Query parse() throws SyntaxError {
        if (this.localParams == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cf QParser miss localParams");
        }
        String name = this.localParams.get(CF_NAME);
        CollectorFilterablePlugin cfPlugin = this.getCollectorFilterablePlugin(name);
        if (cfPlugin == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cf QParser not found '" + name + "' CollectorFilterablePlugin");
        }
        FunctionQuery funQ = (FunctionQuery)super.parse();
        ValueSource vs = funQ.getValueSource();
        String valueStr = null;
        int valueIndex = this.qstr.indexOf(":");
        if (valueIndex > 0 && valueIndex < this.qstr.length() - 1) {
            valueStr = this.qstr.substring(valueIndex + 1);
        }
        CollectorFilterable cf = cfPlugin.createCollectorFilterable(name, this.localParams, this.localParams, this.req, vs, valueStr);
        if (this.localParams.getBool(CF_NOT, false)) {
            cf = new WrappedNotCollectorFilterable(cf);
        }
        return new CollectorFilterQuery(new ValueSourceCollectorFilter(vs, cf));
    }
}

