/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search;

import java.util.Map;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.vootoo.search.FilterCollector;
import org.vootoo.search.function.ValueSourceCollectorFilter;

public class CollectorFilterQuery
extends SolrConstantScoreQuery
implements PostFilter {
    final ValueSourceCollectorFilter valueSourceFilter;

    public CollectorFilterQuery(ValueSourceCollectorFilter valueSourceFilter) {
        super((Filter)valueSourceFilter);
        super.setCache(false);
        super.setCost(120);
        this.valueSourceFilter = valueSourceFilter;
    }

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        Map fcontext = ValueSource.newContext((IndexSearcher)searcher);
        return new FilterCollector(this.valueSourceFilter.getCollectorFilterable(), fcontext);
    }

    public void setCache(boolean cache) {
        if (cache) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, CollectorFilterQuery.class.getSimpleName() + " not support 'cache=true'");
        }
        super.setCache(cache);
    }
}

