/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search.function;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;

public class RandomValueSourceParser
extends ValueSourceParser {
    protected long parseLong(FunctionQParser fp) throws SyntaxError {
        String str = fp.parseArg();
        if (fp.argWasQuoted()) {
            throw new SyntaxError("Expected double instead of quoted string:" + str);
        }
        long value = Long.parseLong(str);
        return value;
    }

    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        int max = Integer.MAX_VALUE;
        Long seed = null;
        if (fp.hasMoreArguments()) {
            max = fp.parseInt();
        }
        if (fp.hasMoreArguments()) {
            seed = this.parseLong(fp);
        }
        return new RandomValueSource(max, seed);
    }

    protected class RandomValueSource
    extends ValueSource {
        private int max = Integer.MAX_VALUE;
        private Long seed = null;
        private ThreadLocal<Random> random = null;

        public RandomValueSource() {
            this(Integer.MAX_VALUE);
        }

        public RandomValueSource(int max) {
            this(max, null);
        }

        public RandomValueSource(int max, final Long seed) {
            this.max = max;
            this.seed = seed;
            this.random = new ThreadLocal<Random>(){

                @Override
                protected Random initialValue() {
                    return seed == null ? new Random() : new Random(seed);
                }
            };
        }

        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            return new IntDocValues(this){

                public int intVal(int doc) {
                    return ((Random)RandomValueSource.this.random.get()).nextInt(RandomValueSource.this.max);
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            RandomValueSource that = (RandomValueSource)((Object)o);
            if (this.max != that.max) {
                return false;
            }
            return this.seed != null ? this.seed.equals(that.seed) : that.seed == null;
        }

        public int hashCode() {
            int result = this.seed != null ? this.seed.hashCode() : 0;
            result = 31 * result + this.max;
            return result;
        }

        public String description() {
            return this.seed == null ? "rand(" + this.max + ")" : "rand(" + this.max + "," + this.seed + ")";
        }
    }
}

