/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search.function.filter;

import org.apache.lucene.queries.function.ValueSource;
import org.vootoo.search.ValueSourceCollectorFilterable;

public class BitCollectorFilterable
extends ValueSourceCollectorFilterable {
    protected final long queryBit;

    public BitCollectorFilterable(ValueSource valueSource, long queryBit) {
        super(valueSource);
        this.queryBit = queryBit;
    }

    @Override
    public String description() {
        return "bit(" + this.valueSource.description() + "):" + this.queryBit;
    }

    @Override
    public boolean matches(int doc) {
        long indexObj = this.functionValues.longVal(doc);
        return (indexObj & this.queryBit) != 0L;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BitCollectorFilterable that = (BitCollectorFilterable)o;
        return this.queryBit == that.queryBit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.queryBit ^ this.queryBit >>> 32);
        return result;
    }
}

