/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search.function.filter;

import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SyntaxError;
import org.vootoo.search.CollectorFilterable;
import org.vootoo.search.CollectorFilterablePlugin;
import org.vootoo.search.function.filter.BitCollectorFilterable;

public class BitCollectorFilterablePlugin
extends CollectorFilterablePlugin {
    public static final String NAME_BIT = "bit";
    public static final String NAME_CONTAIN_BIT = "cbit";

    @Override
    public CollectorFilterable createCollectorFilterable(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, ValueSource valueSource, String valueStr) throws SyntaxError {
        this.verifyValueStr(valueStr, valueSource);
        List<String> lvs = BitCollectorFilterablePlugin.parseMultiValue(valueStr, null, true);
        long queryBit = 0L;
        for (String lv : lvs) {
            Long qv = null;
            try {
                qv = BitCollectorFilterablePlugin.parseLongExt(lv);
            }
            catch (NumberFormatException e) {
                throw new SyntaxError(lv + " can't parse long for '" + this.getName() + "' cf", (Throwable)e);
            }
            if (qv == null) continue;
            queryBit |= qv.longValue();
        }
        return this.createCollectorFilterable(valueSource, queryBit);
    }

    protected CollectorFilterable createCollectorFilterable(ValueSource valueSource, long queryBit) {
        return new BitCollectorFilterable(valueSource, queryBit);
    }

    @Override
    public String getName() {
        return NAME_BIT;
    }
}

