/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search.function.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.queries.function.ValueSource;
import org.vootoo.search.ValueSourceCollectorFilterable;

public class InCollectorFilterable
extends ValueSourceCollectorFilterable {
    private final String[] inValues;
    private Set<Object> inObjValues;

    public InCollectorFilterable(ValueSource valueSource, String[] inValues) {
        super(valueSource);
        this.inValues = inValues;
    }

    @Override
    public String description() {
        return "in(" + this.valueSource.description() + "):" + Arrays.toString(this.inValues);
    }

    @Override
    public boolean matches(int doc) {
        Object obj = this.functionValues.objectVal(doc);
        if (obj == null) {
            return false;
        }
        if (this.inObjValues == null) {
            this.inObjValues = new HashSet<Object>(this.inValues.length * 2);
            for (Object objValue : InCollectorFilterable.parseValue(this.inValues, obj)) {
                this.inObjValues.add(objValue);
            }
        }
        return this.inObjValues.contains(obj);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.inValues);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InCollectorFilterable other = (InCollectorFilterable)obj;
        return Arrays.equals(this.inValues, other.inValues);
    }
}

