/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.vootoo.search.CollectorFilterable;
import org.vootoo.search.function.filter.BitCollectorFilterablePlugin;
import org.vootoo.search.function.filter.BitContainCollectorFilterablePlugin;
import org.vootoo.search.function.filter.InCollectorFilterablePlugin;
import org.vootoo.search.function.filter.RangeCollectorFilterablePlugin;

public abstract class CollectorFilterablePlugin {
    public static final Map<String, CollectorFilterablePlugin> standardPlugins = new HashMap<String, CollectorFilterablePlugin>();
    private static Map<String, Boolean> radix_16;

    public abstract CollectorFilterable createCollectorFilterable(String var1, SolrParams var2, SolrParams var3, SolrQueryRequest var4, ValueSource var5, String var6) throws SyntaxError;

    public abstract String getName();

    public void verifyValueStr(String valueStr, ValueSource valueSource) throws SyntaxError {
        if (valueStr == null) {
            throw new SyntaxError("cf=" + this.getName() + " '" + valueSource.description() + "' value is null");
        }
        if ((valueStr = valueStr.trim()).length() < 1) {
            throw new SyntaxError("cf=" + this.getName() + " '" + valueSource.description() + "' value is blank");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> parseMultiValue(String valueStr, String splitStr, boolean requireValue) throws SyntaxError {
        if (splitStr == null) {
            splitStr = ",";
        }
        valueStr = valueStr.trim();
        ArrayList<String> lvs = new ArrayList<String>();
        if ('(' == valueStr.charAt(0)) {
            if (')' != valueStr.charAt(valueStr.length() - 1)) throw new SyntaxError("value format is 'x or (x[<, n>...])', miss ')' q=" + valueStr);
            String vstr = valueStr.substring(1, valueStr.length() - 1);
            String[] vs = vstr.split(splitStr);
            if (vs == null || vs.length < 1) {
                throw new SyntaxError("value format is 'x or (x[<, n>...])'! q=" + valueStr);
            }
            for (String s : vs) {
                if (s == null || (s = s.trim()).length() <= 0) continue;
                lvs.add(s);
            }
        } else {
            lvs.add(valueStr);
        }
        if (!requireValue || lvs.size() >= 1) return lvs;
        throw new SyntaxError("value format is 'x or (x[<, n>...])', not values! q=" + valueStr);
    }

    public static ValueSourceRangeFilter parseRange(ValueSource vs, String rangeValue) throws SyntaxError {
        boolean includeLower = true;
        boolean includeUpper = true;
        if (rangeValue == null) {
            throw new SyntaxError("range query format error, rangeValue is null");
        }
        if ((rangeValue = rangeValue.trim()).length() < 6) {
            throw new SyntaxError("range query format error, rangeValue=" + rangeValue);
        }
        char ch = rangeValue.charAt(0);
        if (ch == '(') {
            includeLower = false;
        } else if (ch != '[') {
            throw new SyntaxError("range query lower char must be '(' or '[', rangeValue=" + rangeValue);
        }
        ch = rangeValue.charAt(rangeValue.length() - 1);
        if (ch == ')') {
            includeUpper = false;
        } else if (ch != ']') {
            throw new SyntaxError("range query upper char must be ')' or ']', rangeValue=" + rangeValue);
        }
        String l = null;
        String u = null;
        String[] values = rangeValue.substring(1, rangeValue.length() - 1).split("\\ TO\\ ");
        if (values == null || values.length < 2) {
            throw new SyntaxError("range query format error, rangeValue=" + rangeValue);
        }
        values[0] = values[0].trim();
        values[1] = values[1].trim();
        if (values[0].length() > 0 && !values[0].equals("*")) {
            l = values[0];
        }
        if (values[1].length() > 0 && !values[1].equals("*")) {
            u = values[1];
        }
        return new ValueSourceRangeFilter(vs, l, u, includeLower, includeUpper);
    }

    public static Long parseLongExt(String longStr) {
        try {
            return Long.parseLong(longStr);
        }
        catch (NumberFormatException e) {
            if (longStr.length() > 2) {
                String lstr = longStr.substring(0, 2);
                Boolean isRadix16 = radix_16.get(lstr);
                if (isRadix16 == null) {
                    throw e;
                }
                if (isRadix16.booleanValue()) {
                    return Long.parseLong(longStr.substring(2), 16);
                }
                return Long.parseLong(longStr.substring(2), 2);
            }
            throw e;
        }
    }

    static {
        standardPlugins.put("in", new InCollectorFilterablePlugin());
        standardPlugins.put("range", new RangeCollectorFilterablePlugin());
        standardPlugins.put("bit", new BitCollectorFilterablePlugin());
        standardPlugins.put("cbit", new BitContainCollectorFilterablePlugin());
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(4);
        map.put("0x", Boolean.TRUE);
        map.put("0X", Boolean.TRUE);
        map.put("0b", Boolean.FALSE);
        map.put("0B", Boolean.FALSE);
        radix_16 = Collections.unmodifiableMap(map);
    }
}

