/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.search.function.filter;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.vootoo.search.CollectorFilterable;

public class RangeCollectorFilterable
extends CollectorFilterable {
    protected final ValueSourceRangeFilter valueSourceRangeFilter;
    protected ValueSourceScorer rangeScorer;

    public RangeCollectorFilterable(ValueSourceRangeFilter valueSourceRangeFilter) {
        this.valueSourceRangeFilter = valueSourceRangeFilter;
    }

    public ValueSource getValueSource() {
        return this.valueSourceRangeFilter.getValueSource();
    }

    public String getLowerVal() {
        return this.valueSourceRangeFilter.getLowerVal();
    }

    public String getUpperVal() {
        return this.valueSourceRangeFilter.getUpperVal();
    }

    public boolean isIncludeLower() {
        return this.valueSourceRangeFilter.isIncludeLower();
    }

    public boolean isIncludeUpper() {
        return this.valueSourceRangeFilter.isIncludeUpper();
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("range(");
        sb.append(this.getValueSource().description());
        sb.append("):");
        sb.append(this.isIncludeLower() ? (char)'[' : '(');
        sb.append(this.getLowerVal() == null ? "*" : this.getLowerVal());
        sb.append(" TO ");
        sb.append(this.getUpperVal() == null ? "*" : this.getUpperVal());
        sb.append(this.isIncludeUpper() ? (char)']' : ')');
        return sb.toString();
    }

    @Override
    public boolean matches(int doc) {
        if (this.rangeScorer != null) {
            return this.rangeScorer.matches(doc);
        }
        return true;
    }

    @Override
    public void doSetNextReader(Map context, LeafReaderContext readerContext) throws IOException {
        FunctionValues values = this.getValueSource().getValues(context, readerContext);
        this.rangeScorer = values.getRangeScorer(readerContext, this.getLowerVal(), this.getUpperVal(), this.isIncludeLower(), this.isIncludeUpper());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.valueSourceRangeFilter == null ? 0 : this.valueSourceRangeFilter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeCollectorFilterable other = (RangeCollectorFilterable)obj;
        return !(this.valueSourceRangeFilter == null ? other.valueSourceRangeFilter != null : !this.valueSourceRangeFilter.equals((Object)other.valueSourceRangeFilter));
    }
}

