/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.logging.logback;

import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.filter.Filter;
import org.apache.solr.logging.LogWatcher;

public class LogbackEventAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final LogWatcher<ILoggingEvent> watcher;
    private final ThresholdFilter thresholdFilter = new ThresholdFilter();
    private String threshold;

    public LogbackEventAppender(LogWatcher<ILoggingEvent> framework) {
        this.watcher = framework;
        this.addFilter((Filter)this.thresholdFilter);
    }

    protected void append(ILoggingEvent eventObject) {
        this.watcher.add((Object)eventObject, eventObject.getTimeStamp());
    }

    public void start() {
        this.thresholdFilter.start();
        super.start();
    }

    public void stop() {
        this.watcher.reset();
        super.stop();
        this.thresholdFilter.stop();
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String level) {
        this.thresholdFilter.setLevel(level);
        this.threshold = level;
    }
}

