/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.logging.CircularList;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.LoggerInfo;
import org.slf4j.impl.StaticLoggerBinder;
import org.vootoo.logging.logback.LogbackEventAppender;
import org.vootoo.logging.logback.LogbackInfo;

public class LogbackWatcher
extends LogWatcher<ILoggingEvent> {
    private final String name = StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr();
    private LogbackEventAppender appenderBase = null;

    private LoggerContext getLoggerContext() {
        return (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
    }

    private Logger getRootLogger(LoggerContext loggerContext) {
        if (loggerContext == null) {
            loggerContext = this.getLoggerContext();
        }
        return loggerContext.getLogger("ROOT");
    }

    public String getName() {
        return "Logback (" + this.name + ")";
    }

    public List<String> getAllLevels() {
        return Arrays.asList(Level.ALL.toString(), Level.TRACE.toString(), Level.DEBUG.toString(), Level.INFO.toString(), Level.WARN.toString(), Level.ERROR.toString(), Level.OFF.toString());
    }

    public void setLogLevel(String category, String level) {
        LoggerContext loggerContext = this.getLoggerContext();
        Logger log = "root".equals(category) ? this.getRootLogger(loggerContext) : loggerContext.getLogger(category);
        if (level == null || "unset".equals(level) || "null".equals(level)) {
            log.setLevel(null);
        } else {
            log.setLevel(Level.toLevel((String)level));
        }
    }

    public Collection<LoggerInfo> getAllLoggers() {
        LoggerContext loggerContext = this.getLoggerContext();
        HashMap<String, LogbackInfo> map = new HashMap<String, LogbackInfo>();
        Logger root = this.getRootLogger(loggerContext);
        List loggers = loggerContext.getLoggerList();
        for (Logger logger : loggers) {
            int dot;
            if (root == logger) continue;
            String name = logger.getName();
            map.put(name, new LogbackInfo(name, logger));
            while ((dot = name.lastIndexOf(".")) >= 0) {
                if (map.containsKey(name = name.substring(0, dot))) continue;
                map.put(name, new LogbackInfo(name, null));
            }
        }
        map.put("root", new LogbackInfo("root", root));
        return map.values();
    }

    public void setThreshold(String level) {
        if (this.appenderBase == null) {
            throw new IllegalStateException("Must have an appender");
        }
        this.appenderBase.setThreshold(level);
    }

    public String getThreshold() {
        if (this.appenderBase == null) {
            throw new IllegalStateException("Must have an appender");
        }
        return this.appenderBase.getThreshold();
    }

    public void registerListener(ListenerConfig cfg) {
        if (this.history != null) {
            throw new IllegalStateException("History already registered");
        }
        this.history = new CircularList(cfg.size);
        this.appenderBase = new LogbackEventAppender(this);
        if (cfg.threshold != null) {
            this.appenderBase.setThreshold(cfg.threshold);
        } else {
            this.appenderBase.setThreshold(Level.WARN.toString());
        }
        this.appenderBase.start();
        Logger log = this.getRootLogger(null);
        log.addAppender((Appender)this.appenderBase);
    }

    public long getTimestamp(ILoggingEvent event) {
        return event.getTimeStamp();
    }

    public SolrDocument toSolrDocument(ILoggingEvent event) {
        SolrDocument doc = new SolrDocument();
        doc.setField("time", (Object)new Date(event.getTimeStamp()));
        doc.setField("level", (Object)event.getLevel().toString());
        doc.setField("logger", (Object)event.getLoggerName());
        doc.setField("message", (Object)event.getFormattedMessage());
        ThrowableProxy t = (ThrowableProxy)event.getThrowableProxy();
        if (t != null) {
            doc.setField("trace", (Object)Throwables.getStackTraceAsString((Throwable)t.getThrowable()));
        }
        return doc;
    }
}

