/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server.netty;

import java.io.OutputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.client.netty.util.ByteStringer;
import org.vootoo.client.netty.util.ProtobufUtil;
import org.vootoo.common.MemoryOutputStream;
import org.vootoo.server.ResponseSetter;

public class ProtobufResponseSetter
implements ResponseSetter<SolrProtocol.SolrResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufResponseSetter.class);
    private SolrProtocol.SolrResponse.Builder protocolResponseBuilder = SolrProtocol.SolrResponse.newBuilder();
    private SolrProtocol.ResponseBody.Builder responseBodyBuilder;
    private SolrQueryResponse solrQueryResponse;
    private MemoryOutputStream responeOutput;

    public ProtobufResponseSetter(long rid) {
        this.protocolResponseBuilder.setRid(rid);
    }

    private void checkResponseBodyBuilder() {
        if (this.responseBodyBuilder == null) {
            this.responseBodyBuilder = SolrProtocol.ResponseBody.newBuilder();
        }
    }

    @Override
    public void setContentType(String contentType) {
        this.checkResponseBodyBuilder();
        this.responseBodyBuilder.setContentType(contentType);
    }

    @Override
    public OutputStream getResponseOutputStream() {
        if (this.responeOutput == null) {
            this.responeOutput = new MemoryOutputStream();
        }
        return this.responeOutput;
    }

    @Override
    public void setSolrResponseException(int code, NamedList info) {
        String trace;
        SolrProtocol.ExceptionBody.Builder exceptionBody = SolrProtocol.ExceptionBody.newBuilder();
        exceptionBody.setCode(code);
        ProtobufUtil.fillErrorMetadata((SolrProtocol.ExceptionBody.Builder)exceptionBody, (NamedList)((NamedList)info.get("metadata")));
        Object msg = info.get("msg");
        if (msg != null) {
            exceptionBody.setMessage(String.valueOf(msg));
        }
        if ((trace = (String)info.get("trace")) != null) {
            exceptionBody.setTrace(trace);
        }
        this.protocolResponseBuilder.addExceptionBody(exceptionBody);
    }

    @Override
    public void addError(int code, String message) {
        SolrProtocol.ExceptionBody.Builder exceptionBody = SolrProtocol.ExceptionBody.newBuilder();
        exceptionBody.setCode(code);
        exceptionBody.setMessage(message);
        this.protocolResponseBuilder.addExceptionBody(exceptionBody);
    }

    @Override
    public void addError(Throwable ex) {
        this.addError(500, ex);
    }

    @Override
    public void addError(int code, Throwable ex) {
        SolrProtocol.ExceptionBody.Builder exceptionBody = SolrProtocol.ExceptionBody.newBuilder();
        int errorCode = ProtobufUtil.getErrorInfo((Throwable)ex, (SolrProtocol.ExceptionBody.Builder)exceptionBody);
        if (errorCode == 500 && code != 500 && code >= 100) {
            exceptionBody.setCode(code);
        }
        this.protocolResponseBuilder.addExceptionBody(exceptionBody);
        logger.error(ex.getMessage(), ex);
    }

    @Override
    public void writeQueryResponseComplete(SolrQueryResponse solrQueryResponse) {
        this.solrQueryResponse = solrQueryResponse;
        if (this.responeOutput != null) {
            this.checkResponseBodyBuilder();
            this.responseBodyBuilder.setBody(ByteStringer.wrap((byte[])this.responeOutput.getBuffer(), (int)0, (int)this.responeOutput.getCount()));
            this.protocolResponseBuilder.setResponseBody(this.responseBodyBuilder);
        } else {
            logger.warn("SolrQueryResponse write completed, but not found in OutputStream, responeOutput is null.");
        }
    }

    @Override
    public SolrQueryResponse getSolrQueryResponse() {
        return this.solrQueryResponse;
    }

    @Override
    public SolrProtocol.SolrResponse buildProtocolResponse() {
        return this.protocolResponseBuilder.build();
    }
}

