/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server.netty;

import com.google.protobuf.MessageLite;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import org.apache.solr.core.CoreContainer;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.server.RequestExecutor;
import org.vootoo.server.netty.ChannelHandlerConfigs;
import org.vootoo.server.netty.SolrServerHandler;

public class SolrServerChannelInitializer
extends ChannelInitializer<Channel> {
    private final CoreContainer coreContainer;
    private final ChannelHandlerConfigs handlerConfigs;
    private final RequestExecutor queryExecutor;
    private final RequestExecutor updateExecutor;

    public SolrServerChannelInitializer(CoreContainer coreContainer, ChannelHandlerConfigs handlerConfigs, RequestExecutor queryExecutor, RequestExecutor updateExecutor) {
        this.coreContainer = coreContainer;
        this.handlerConfigs = handlerConfigs;
        this.queryExecutor = queryExecutor;
        this.updateExecutor = updateExecutor;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("frame-decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.handlerConfigs.getMaxFrameLength(), 0, 4, 0, 4));
        pipeline.addLast("frame-encoder", (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast("pb-decoder", (ChannelHandler)new ProtobufDecoder((MessageLite)SolrProtocol.SolrRequest.getDefaultInstance()));
        pipeline.addLast("pb-encoder", (ChannelHandler)new ProtobufEncoder());
        pipeline.addLast(new ChannelHandler[]{new SolrServerHandler(this.coreContainer, this.queryExecutor, this.updateExecutor)});
    }
}

