/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.server.netty.SolrNettyServer;

public class VootooSolrDispatchFilter
extends SolrDispatchFilter {
    private static final Logger logger = LoggerFactory.getLogger(VootooSolrDispatchFilter.class);
    private static final String NETTY_PROPERTIES = "netty.properties";
    protected volatile SolrNettyServer nettyServer;

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.initNettyServer(this.getCores());
    }

    public void destroy() {
        this.destroyNettyServer();
        super.destroy();
    }

    protected void initNettyServer(CoreContainer cores) {
        String solrHome = cores.getSolrHome();
        Properties nettyP = new Properties();
        File nettyProp = new File(solrHome, NETTY_PROPERTIES);
        if (nettyProp != null && nettyProp.isFile() && nettyProp.canRead()) {
            try {
                nettyP.load(new FileInputStream(nettyProp));
            }
            catch (IOException e) {
                logger.warn("loading from=" + nettyProp.getAbsolutePath() + " is fail, ignore netty properties", (Throwable)e);
            }
        }
        this.nettyServer = new SolrNettyServer(this.getCores(), Integer.parseInt(nettyP.getProperty("port", "8001")));
        try {
            this.nettyServer.startServer(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.nettyServer = null;
        }
    }

    protected void destroyNettyServer() {
        if (this.nettyServer != null) {
            try {
                this.nettyServer.stopServer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

