/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.vrspace.server.core.Scene;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.PersistentEvent;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.VRObject;

public class EventRecorder
extends Client {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventRecorder.class);
    private boolean recordClient = true;
    private boolean recordScene = true;
    private boolean loop = true;
    private Long length;
    @JsonIgnore
    private Collection<PersistentEvent> events = new ConcurrentLinkedQueue<PersistentEvent>();
    @JsonIgnore
    @Transient
    private transient Client client;
    @Transient
    @JsonIgnore
    private transient boolean recording = false;
    @Transient
    @JsonIgnore
    private transient long start = 0L;
    @Transient
    @JsonIgnore
    private volatile transient boolean playing = false;
    @Transient
    @JsonIgnore
    ScheduledExecutorService restart;

    public EventRecorder() {
    }

    public EventRecorder(WorldManager worldManager, Client client, String name) {
        this.setName(name);
        this.setWorldId(client.getWorldId());
        this.setPosition(new Point(client.getPosition()));
        this.setSceneProperties(client.getSceneProperties());
        this.setMesh(client.getMesh());
        this.setActive(true);
    }

    public void init(WorldManager worldManager, Client client) {
        this.client = client;
        this.setMapper(client.getMapper());
        if (this.recordClient) {
            client.addListener(this);
        }
        if (this.recordScene) {
            this.setScene(new Scene(worldManager, this));
        }
    }

    public void start() {
        if (this.recordScene && this.getScene() == null) {
            throw new IllegalStateException("Scene is null");
        }
        this.recording = true;
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        if (this.recordScene && this.getScene() == null) {
            throw new IllegalStateException("Scene is null");
        }
        this.recording = false;
        this.length = System.currentTimeMillis() - this.start;
    }

    @Override
    public void processEvent(VREvent event) {
        this.sendMessage(event);
    }

    @Override
    public void sendMessage(Object obj) {
        if (this.recording) {
            try {
                long delay = System.currentTimeMillis() - this.start;
                if (obj instanceof VREvent) {
                    VREvent event = (VREvent)obj;
                    if (event.getPayload() == null) {
                        event.setPayload(this.getMapper().writeValueAsString(event.getChanges()));
                    }
                    if (event.getSource() == this.client) {
                        log.debug(this.getName() + " Recording own message " + delay + ":" + obj);
                        this.events.add(new PersistentEvent(delay, "own", event, this));
                    } else {
                        log.debug(this.getName() + " Recording space event " + delay + ":" + obj);
                        this.events.add(new PersistentEvent(delay, "world", event, event.getSource()));
                    }
                } else if (obj instanceof Command) {
                    Command cmd = (Command)obj;
                    log.debug(this.getName() + " Recording scene update " + delay + ":" + obj);
                    this.events.add(new PersistentEvent(delay, "scene", cmd));
                } else {
                    log.error(this.getName() + " Unsupported message type: " + obj);
                }
            }
            catch (Exception e) {
                log.error(this.getName() + " Can't record message " + obj, (Throwable)e);
            }
        }
    }

    public void play() {
        log.debug(this.getName() + " Playing " + this.events.size() + " events...");
        if (this.events.size() > 0 && this.getListeners().size() > 0) {
            this.playing = true;
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            this.events.stream().filter(event -> "own".equals(event.getType())).forEach(event -> executor.schedule(() -> this.playEvent((PersistentEvent)event), event.getDelay(), TimeUnit.MILLISECONDS));
            executor.shutdown();
            if (this.length != null) {
                this.restart = Executors.newSingleThreadScheduledExecutor();
                if (this.loop) {
                    this.restart.schedule(() -> this.play(), (long)this.length, TimeUnit.MILLISECONDS);
                } else {
                    this.restart.schedule(() -> {
                        this.playing = false;
                        return false;
                    }, (long)this.length, TimeUnit.MILLISECONDS);
                }
                this.restart.shutdown();
            }
        } else {
            this.playing = false;
        }
    }

    private void playEvent(PersistentEvent event) {
        try {
            if (event.getChanges() == null) {
                VREvent changed = (VREvent)this.getMapper().readValue(event.getPayload(), VREvent.class);
                event.setChanges(changed.getChanges());
            }
            this.notifyListeners(event.getEvent());
        }
        catch (Exception e) {
            log.error(this.getName() + " Can't play event " + event, (Throwable)e);
        }
    }

    public void play(Client viewer) {
        log.debug(this.getName() + " Playing " + this.events.size() + " events to Client " + viewer);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        this.events.forEach(event -> executor.schedule(() -> this.playEvent((PersistentEvent)event, viewer), event.getDelay(), TimeUnit.MILLISECONDS));
        executor.shutdown();
        if (this.loop && this.length != null) {
            this.restart = Executors.newSingleThreadScheduledExecutor();
            this.restart.schedule(() -> this.play(viewer), (long)this.length, TimeUnit.MILLISECONDS);
            this.restart.shutdown();
        }
    }

    private void playEvent(PersistentEvent event, Client viewer) {
        try {
            viewer.sendMessage(event.getMessage());
        }
        catch (Exception e) {
            log.error("Error playing event " + event, (Throwable)e);
        }
    }

    @Override
    public void addListener(VRObject obj) {
        if (this.getListeners() == null || this.getListeners().size() == 0) {
            super.addListener(obj);
            if (this.getMapper() == null) {
                this.setMapper(((Client)obj).getMapper());
            }
            if (this.loop && !this.playing) {
                this.play();
            }
        } else {
            super.addListener(obj);
        }
    }

    public Collection<PersistentEvent> getEvents() {
        return this.events;
    }

    @Generated
    public boolean isRecordClient() {
        return this.recordClient;
    }

    @Generated
    public boolean isRecordScene() {
        return this.recordScene;
    }

    @Generated
    public boolean isLoop() {
        return this.loop;
    }

    @Generated
    public Long getLength() {
        return this.length;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public boolean isRecording() {
        return this.recording;
    }

    @Generated
    public long getStart() {
        return this.start;
    }

    @Generated
    public boolean isPlaying() {
        return this.playing;
    }

    @Generated
    public ScheduledExecutorService getRestart() {
        return this.restart;
    }

    @Generated
    public void setRecordClient(boolean recordClient) {
        this.recordClient = recordClient;
    }

    @Generated
    public void setRecordScene(boolean recordScene) {
        this.recordScene = recordScene;
    }

    @Generated
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Generated
    public void setLength(Long length) {
        this.length = length;
    }

    @JsonIgnore
    @Generated
    public void setEvents(Collection<PersistentEvent> events) {
        this.events = events;
    }

    @JsonIgnore
    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @JsonIgnore
    @Generated
    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    @JsonIgnore
    @Generated
    public void setStart(long start) {
        this.start = start;
    }

    @JsonIgnore
    @Generated
    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    @JsonIgnore
    @Generated
    public void setRestart(ScheduledExecutorService restart) {
        this.restart = restart;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventRecorder)) {
            return false;
        }
        EventRecorder other = (EventRecorder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventRecorder;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "EventRecorder(super=" + super.toString() + ")";
    }
}

