/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;
import org.vrspace.server.core.ClassUtil;

@Component
public class ContentTomcatCustomizer
implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
    private static final Logger log = LoggerFactory.getLogger(ContentTomcatCustomizer.class);

    public void customize(TomcatServletWebServerFactory factory) {
        String serverDir = ClassUtil.projectHomeDirectory();
        if (serverDir == null) {
            log.error("Can't determine project home directory");
        } else {
            File contentDir = new File(serverDir);
            factory.setDocumentRoot(contentDir);
            factory.setContextPath("");
            factory.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                public void customize(Context context) {
                    Wrapper defServlet = (Wrapper)context.findChild("default");
                    if (defServlet == null) {
                        log.info("Server is not serving static content - server.servlet.register-default-servlet disabled");
                    } else {
                        defServlet.addInitParameter("listings", "true");
                        defServlet.addInitParameter("readOnly", "false");
                        defServlet.addInitParameter("debug", "1");
                        defServlet.addMapping("/content/*");
                        defServlet.addMapping("/babylon/*");
                        defServlet.addMapping("/web/*");
                    }
                }
            }});
        }
    }
}

