/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.security.Principal;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.vrspace.server.core.ClientFactory;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.Client;

@Component
public class DefaultClientFactory
implements ClientFactory {
    @Override
    public <T extends Client> T createGuestClient(Class<T> clientClass, HttpHeaders headers, Map<String, Object> attributes) {
        try {
            Client ret = (Client)clientClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ret.setGuest(true);
            return (T)ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create client of class " + String.valueOf(clientClass));
        }
    }

    @Override
    public <T extends Client> T findClient(Class<T> clientClass, Principal principal, VRObjectRepository db, HttpHeaders headers, Map<String, Object> attributes) {
        Object name = attributes.get(this.clientAttribute());
        if (name != null && name instanceof String) {
            return (T)db.getClientByName((String)name, clientClass);
        }
        throw new SecurityException("Unknown client name: " + String.valueOf(name));
    }
}

