/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import lombok.Generated;
import org.vrspace.server.core.CustomTypeIdResolver;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.Client;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public class Echo
implements Command {
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @JsonTypeIdResolver(value=CustomTypeIdResolver.class)
    public Command command;
    public VREvent event;

    public Echo(Command command) {
        this.command = command;
    }

    public Echo(VREvent event) {
        this.event = event;
    }

    @Override
    public ClientResponse execute(WorldManager world, Client client) {
        if (this.command != null) {
            client.sendMessage(this.command);
        } else if (this.event != null) {
            client.sendMessage(this.event);
        } else {
            throw new IllegalArgumentException("Nothing to echo");
        }
        return null;
    }

    @Generated
    public Command getCommand() {
        return this.command;
    }

    @Generated
    public VREvent getEvent() {
        return this.event;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @Generated
    public void setCommand(Command command) {
        this.command = command;
    }

    @Generated
    public void setEvent(VREvent event) {
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Echo)) {
            return false;
        }
        Echo other = (Echo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Command this$command = this.getCommand();
        Command other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        VREvent this$event = this.getEvent();
        VREvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Echo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Command $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        VREvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Echo(command=" + String.valueOf(this.getCommand()) + ", event=" + String.valueOf(this.getEvent()) + ")";
    }

    @Generated
    public Echo() {
    }
}

