/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.server.core.SessionException;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.obj.Client;

public class Log
implements Command {
    private static final Logger log = LoggerFactory.getLogger(Log.class);
    String message;
    String severity;

    @Override
    public ClientResponse execute(WorldManager manager, Client client) throws ClassNotFoundException, SessionException {
        if (this.severity == null) {
            this.severity = "debug";
        }
        String logEntry = "Client " + String.valueOf(client.getId()) + ": " + this.message;
        switch (this.severity) {
            case "debug": {
                log.debug(logEntry);
                break;
            }
            case "info": {
                log.info(logEntry);
                break;
            }
            case "warn": {
                log.warn(logEntry);
                break;
            }
            case "error": {
                log.error(logEntry);
                break;
            }
            default: {
                log.error("Invalid log level received from Client " + String.valueOf(client.getId()) + ": " + this.severity + " Message: " + logEntry);
            }
        }
        return null;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getSeverity() {
        return this.severity;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log other = (Log)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        return !(this$severity == null ? other$severity != null : !this$severity.equals(other$severity));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Log;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Log(message=" + this.getMessage() + ", severity=" + this.getSeverity() + ")";
    }

    @Generated
    public Log() {
    }
}

