/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.EventRecorder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public class Recording
implements Command {
    private static final Logger log = LoggerFactory.getLogger(Recording.class);
    private String action;
    private String name;

    @Override
    public ClientResponse execute(WorldManager worldManager, Client client) {
        Client recorderClient;
        EventRecorder recorder = null;
        if (this.name == null) {
            this.name = "Recorder:" + String.valueOf(client.getId());
        }
        if ((recorderClient = worldManager.getClientByName(this.name)) == null) {
            recorder = new EventRecorder(worldManager, client, this.name);
            recorder.setRecordClient(true);
            recorder.setRecordScene(false);
            recorder.setLoop(true);
            worldManager.save(recorder);
            log.debug("Created new recorder for " + String.valueOf(client));
        } else if (recorderClient instanceof EventRecorder) {
            recorder = (EventRecorder)recorderClient;
            log.debug("Found recorder " + String.valueOf(recorder));
        }
        if ("record".equals(this.action)) {
            recorder.init(worldManager, client);
            recorder.start();
        } else if ("play".equals(this.action)) {
            recorder.play();
        } else if ("stop".equals(this.action)) {
            recorder.stop();
            worldManager.save(recorder);
            log.debug("Saved recorder " + String.valueOf(recorder));
            client.getScene().setDirty();
            client.getScene().update();
        } else {
            throw new IllegalArgumentException("Invalid action: " + this.action);
        }
        return null;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recording)) {
            return false;
        }
        Recording other = (Recording)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Recording;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Recording(action=" + this.getAction() + ", name=" + this.getName() + ")";
    }

    @Generated
    public Recording() {
    }
}

