/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.server.dto.ClientRequest;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.Enter;
import org.vrspace.server.dto.Session;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.dto.Welcome;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.VRObject;

public class VRSpaceClient
implements WebSocket.Listener,
Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VRSpaceClient.class);
    private ObjectMapper mapper;
    private URI uri;
    private WebSocket ws;
    private List<Function<String, Void>> messageListeners = new ArrayList();
    private List<Function<Welcome, Void>> welcomeListeners = new ArrayList();
    private List<Function<VREvent, Void>> eventListeners = new ArrayList();
    private StringBuilder text = new StringBuilder();
    private CountDownLatch latch;
    private volatile Client client;
    private int errorCount = 0;
    private ScheduledFuture<?> task;
    private String world = null;
    private CompletableFuture<WebSocket> future;
    private Map<String, String> settings = null;
    public static final long TIMEOUT = 5000L;
    public static final long RETRY = 10000L;

    public VRSpaceClient(URI uri, ObjectMapper mapper) {
        this.uri = uri;
        this.mapper = mapper;
    }

    public CompletableFuture<WebSocket> connect() {
        this.latch = new CountDownLatch(1);
        this.future = new CompletableFuture();
        this.task = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)this, 0L, 10000L, TimeUnit.MILLISECONDS);
        return this.future;
    }

    public void startSession() {
        this.send((Command)new Session());
    }

    public void connectAndEnter(String world) {
        this.connectAndEnter(world, this.settings);
    }

    public void connectAndEnter(String world, Map<String, String> params) {
        this.connect().thenApply(ws -> {
            this.await();
            if (params != null) {
                this.settings = params;
                ClientRequest settings = new ClientRequest((VRObject)this.getClient());
                params.entrySet().forEach(e -> settings.addChange((String)e.getKey(), e.getValue()));
                this.send(settings);
            }
            this.enter(world);
            this.await();
            this.send((Command)new Session());
            return ws;
        });
    }

    @Override
    public void run() {
        ((CompletableFuture)((CompletableFuture)HttpClient.newHttpClient().newWebSocketBuilder().connectTimeout(Duration.ofMillis(5000L)).buildAsync(this.uri, (WebSocket.Listener)this).thenApply(ws -> {
            this.ws = ws;
            this.task.cancel(true);
            this.future.complete(ws);
            return ws;
        })).handle((ws, exception) -> {
            if (exception != null) {
                log.error("Websocket exception connecting to " + this.uri + " - " + exception);
            }
            return null;
        })).join();
    }

    public VRSpaceClient addEventListener(Function<VREvent, Void> listener) {
        this.eventListeners.add(listener);
        return this;
    }

    public VRSpaceClient addMessageListener(Function<String, Void> listener) {
        this.messageListeners.add(listener);
        return this;
    }

    public VRSpaceClient addWelcomeListener(Function<Welcome, Void> listener) {
        this.welcomeListeners.add(listener);
        return this;
    }

    public void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            log.error("Unexpected interrupt: ", (Throwable)e);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void enter(String world) {
        this.send((Command)new Enter(world));
        this.world = world;
    }

    public void send(String arg) {
        this.ws.sendText(arg, true);
    }

    public void send(ClientRequest req) {
        try {
            String text = this.mapper.writeValueAsString((Object)req);
            log.debug("Sending " + text);
            this.ws.sendText(text, true);
        }
        catch (Exception e) {
            log.error("OOPS", (Throwable)e);
        }
    }

    public void send(Command cmd) {
        ClientRequest req = new ClientRequest(this.client, cmd);
        this.send(req);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        log.info("Connected to " + this.uri);
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        log.debug("Received " + last + ":" + data);
        this.text.append(data);
        if (last) {
            String message = this.text.toString();
            this.messageListeners.forEach(l -> l.apply(message));
            this.text = new StringBuilder();
            try {
                if (message.startsWith("{\"Welcome\":{")) {
                    Welcome welcome = (Welcome)this.mapper.readValue(message, Welcome.class);
                    this.client = welcome.getClient();
                    this.latch.countDown();
                    this.welcomeListeners.forEach(l -> l.apply(welcome));
                } else if (message.startsWith("{\"ERROR\"")) {
                    ++this.errorCount;
                } else {
                    VREvent event = (VREvent)this.mapper.readValue(message, VREvent.class);
                    this.eventListeners.forEach(l -> l.apply(event));
                }
            }
            catch (Exception e) {
                log.error("Message parsing or processing error", (Throwable)e);
            }
        }
        CompletionStage<?> ret = WebSocket.Listener.super.onText(webSocket, data, last);
        return ret;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        log.error("Websocket error " + webSocket);
        this.connectAndEnter(this.world);
        WebSocket.Listener.super.onError(webSocket, error);
    }

    @Override
    public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
        return WebSocket.Listener.super.onPing(webSocket, message);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        log.debug("Socket closed: " + statusCode + " " + reason);
        this.connectAndEnter(this.world);
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }
}

