/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.SketchfabController;
import org.vrspace.server.core.ClassUtil;
import org.vrspace.server.core.FileUtil;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.ContentCategory;
import org.vrspace.server.obj.GltfModel;

@RestController
@RequestMapping(value={"/vrspace/api/sketchfab"})
public class SketchfabController
extends ApiBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SketchfabController.class);
    public static final String PATH = "/vrspace/api/sketchfab";
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    VRObjectRepository db;
    private final String loginUrl = "https://sketchfab.com/oauth2/token/";
    @Value(value="${sketchfab.clientId:none}")
    private String clientId;
    @Value(value="${sketchfab.clientSecret:none}")
    private String clientSecret;
    @Value(value="${sketchfab.redirectUri:none}")
    private String redirectUri;
    private String token;
    private String referrer;

    @GetMapping(value={"/login"})
    public LoginResponse login(HttpServletRequest request) {
        this.referrer = request.getHeader("Referer");
        LoginResponse ret = new LoginResponse("https://sketchfab.com/oauth2/authorize/?response_type=code&client_id=" + this.clientId + "&redirect_uri=" + this.redirectUri);
        return ret;
    }

    @GetMapping(value={"/oauth2"})
    public ResponseEntity<String> callback(String code) {
        log.info("Login code " + code);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"code", (Object)code);
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"redirect_uri", (Object)this.redirectUri);
        HttpEntity request = this.authRequest((MultiValueMap)map);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("https://sketchfab.com/oauth2/token/", (Object)request, AuthResponse.class, new Object[0]);
        log.debug("Login response: " + response);
        AuthResponse auth = (AuthResponse)response.getBody();
        if (auth.getExpires_in() < 604800) {
            auth = this.refresh(auth.getRefresh_token());
        }
        this.token = auth.getAccess_token();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).header("Location", new String[]{this.referrer})).body((Object)("Redirecting to " + this.referrer));
    }

    private HttpEntity<MultiValueMap<String, String>> authRequest(MultiValueMap<String, String> fields) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity(fields, (MultiValueMap)headers);
        return request;
    }

    private AuthResponse refresh(String refreshToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"refresh_token", (Object)refreshToken);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("https://sketchfab.com/oauth2/token/", (Object)this.authRequest((MultiValueMap)map), AuthResponse.class, new Object[0]);
        log.debug("Refresh response: " + response);
        return (AuthResponse)response.getBody();
    }

    @GetMapping(value={"/download"})
    public ResponseEntity<GltfModel> download(String uid, HttpServletRequest request) {
        GltfModel model;
        if (this.token == null) {
            this.referrer = request.getHeader("Referer");
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        Optional existing = this.db.findGltfModelByUid(uid);
        if (existing.isPresent()) {
            model = (GltfModel)existing.get();
            log.warn("Model already already exists: " + ((GltfModel)existing.get()).getId());
            File modelFile = new File(ClassUtil.projectHomeDirectory() + "/content/" + model.mainCategory() + "/" + model.getFileName());
            if (modelFile.exists()) {
                log.warn("Model directory also exists, exiting: " + modelFile);
                return new ResponseEntity((Object)model, HttpStatus.OK);
            }
            log.warn("Model directory does not exist, downloading again");
        }
        String url = "https://api.sketchfab.com/v3/models/" + uid + "/download";
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(this.token);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, entity, DownloadResponse.class, new Object[0]);
        log.debug("Download response: " + response);
        FileInfo gltf = ((DownloadResponse)response.getBody()).getGltf();
        try {
            model = this.modelInfo(uid);
            if (existing.isPresent()) {
                model.setId(((GltfModel)existing.get()).getId());
                log.warn("Overriding existing model data " + model.getId());
            }
            String category = model.mainCategory();
            URL fileUrl = new URL(gltf.getUrl());
            String fileName = fileUrl.getPath();
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            String modelName = fileName.substring(0, fileName.lastIndexOf("."));
            modelName = modelName.replaceAll("\\.", "");
            File modelDir = new File(FileUtil.contentDir() + "/" + category + "/" + modelName);
            if (modelDir.exists()) {
                log.warn("Destination directory already exists, download skipped: " + modelDir);
            } else {
                log.info("Downloading " + gltf.getUrl() + " size " + gltf.getSize());
                File file = new File(FileUtil.downloadDir(), fileName);
                IOUtils.copy((URL)fileUrl, (File)file);
                log.info("Downloaded to " + file.getCanonicalPath());
                Path dest = FileUtil.unzip((File)file, (File)modelDir);
                log.info("Unzipped to " + dest);
            }
            model.setFileName(modelDir.getName());
            model.setMesh("/content/" + model.mainCategory() + "/" + model.getFileName() + "/scene.gltf");
            this.db.save((Object)model);
            log.info("Stored " + model);
            return new ResponseEntity((Object)model, HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException("Error downloading " + gltf.getUrl(), e);
        }
    }

    private GltfModel modelInfo(String uid) throws JsonMappingException, JsonProcessingException {
        GltfModel ret = new GltfModel();
        RestTemplate restTemplate = new RestTemplate();
        String url = "https://api.sketchfab.com/v3/models/" + uid;
        String json = (String)restTemplate.getForEntity(url, String.class, new Object[0]).getBody();
        log.debug("Model info: " + json);
        Map info = (Map)this.objectMapper.readValue(json, Map.class);
        ret.setUid((String)info.get("uid"));
        ret.setUri((String)info.get("uri"));
        ret.setName((String)info.get("name"));
        ret.setDescription((String)info.get("description"));
        ret.setLicense((String)((Map)info.get("license")).get("slug"));
        ret.setAuthor((String)((Map)info.get("user")).get("displayName"));
        List categories = (List)info.get("categories");
        for (Map category : categories) {
            log.debug("Category: " + category.get("slug") + " " + category.get("name"));
            String catName = (String)category.get("slug");
            Optional oCat = this.db.findContentCategoryByName(catName);
            if (oCat.isPresent()) {
                ret.getCategories().add((ContentCategory)oCat.get());
                continue;
            }
            ContentCategory cat = new ContentCategory(catName);
            cat = (ContentCategory)this.db.save((Object)cat);
            ret.getCategories().add(cat);
        }
        return ret;
    }
}

