/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vrspace.client.VRSpaceClient;
import org.vrspace.server.config.ServerConfig;

@Configuration
@ConditionalOnProperty(name={"org.vrspace.server.advertise"}, havingValue="true")
public class ClientConfig {
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    ServerConfig serverConfig;

    @Bean
    public VRSpaceClient connectToVRSpace() {
        URI uri = URI.create("wss://www.vrspace.org/vrspace/server");
        VRSpaceClient client = new VRSpaceClient(uri, this.objectMapper);
        client.connectAndEnter("galaxy", Map.of("url", this.serverConfig.getServerUrl(), "thumbnail", this.serverConfig.getServerThumbnail(), "description", this.serverConfig.getServerDescripton()));
        return client;
    }
}

