/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.vrspace.server.config.JacksonConfig;
import org.vrspace.server.core.ClassUtil;
import org.vrspace.server.obj.VRObject;

@Configuration
public class JacksonConfig {
    private Pattern htmlTag = Pattern.compile("<.+?>");

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper ret = this.objectMapperBuilder().build();
        ClassUtil.findSubclasses(VRObject.class).forEach(c -> ret.registerSubtypes(new Class[]{c}));
        ret.setAnnotationIntrospector((AnnotationIntrospector)new /* Unavailable Anonymous Inner Class!! */);
        return ret;
    }

    @Bean
    public Jackson2ObjectMapperBuilder objectMapperBuilder() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.featuresToEnable(new Object[]{DeserializationFeature.USE_LONG_FOR_INTS});
        builder.deserializerByType(String.class, (JsonDeserializer)new SanitizeStringDeserializer(this));
        builder.serializerByType(String.class, (JsonSerializer)new SanitizeStringSerializer(this));
        builder.featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        JavaTimeModule module = new JavaTimeModule();
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd['T'HH:mm[:ss[.SSSSSSSSS]]]")));
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd['T'HH:mm[:ss[.SSSSSSSSS]]]")));
        builder.modules(new Module[]{module});
        return builder;
    }

    private String removeHtmlTags(String arg) {
        return this.htmlTag.matcher(arg).replaceAll("");
    }
}

