/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vrspace.server.config.SeleniumConfig;

@Configuration
@WebListener
public class SeleniumConfig
implements HttpSessionListener,
ServletContextListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SeleniumConfig.class);
    private static ConcurrentHashMap<WebSession, WebSession> sessions = new ConcurrentHashMap();

    public void sessionDestroyed(HttpSessionEvent se) {
        log.debug("Session destroyed");
        WebSession session = (WebSession)se.getSession().getAttribute("webDriver");
        if (session != null) {
            session.quit();
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="org.vrspace.server", name={"selenium-enabled"}, havingValue="true")
    WebSessionFactory factory() {
        log.warn("Enabling remote browsing - security risk");
        WebDriverManager.firefoxdriver().setup();
        return new WebSessionFactory(this);
    }

    @Bean
    ServletListenerRegistrationBean<HttpSessionListener> sessionListener() {
        log.info("Servlet context initialized, installing web garbage collector");
        return new ServletListenerRegistrationBean((EventListener)this);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.debug("ServletContext destroyed, cleaning up " + sessions.size() + " web sessions");
        ((ConcurrentHashMap.KeySetView)sessions.keySet()).forEach(e -> e.quit());
    }
}

