/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;

public class CustomTypeIdResolver
extends TypeIdResolverBase {
    private JavaType superType;

    public void init(JavaType baseType) {
        this.superType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromValueAndType(Object obj, Class<?> subType) {
        return subType.getSimpleName();
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        Class<?> subType;
        try {
            subType = Class.forName("org.vrspace.server.dto." + id);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown command " + id, e);
        }
        return context.constructSpecializedType(this.superType, subType);
    }
}

