/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.vrspace.server.core.SessionException;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientRequest;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.dto.Welcome;
import org.vrspace.server.obj.Client;

@Component
public class SessionManager
extends TextWebSocketHandler
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    public static final int SEND_TIMEOUT = 1000;
    public static final int BUFFER_SIZE = 65536;
    public static final int PING_PERIOD = 10000;
    private ConcurrentHashMap<String, Client> sessions = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, Client> clients = new ConcurrentHashMap();
    private ScheduledExecutorService pingScheduler = Executors.newSingleThreadScheduledExecutor();
    private volatile ScheduledFuture<?> pingFuture;
    @Autowired
    private WorldManager worldManager;
    @Autowired
    private ObjectMapper mapper;

    public void handleTextMessage(WebSocketSession session, TextMessage message) {
        Client client = (Client)this.sessions.get(session.getId());
        if (client == null) {
            throw new IllegalStateException("Uknown client for session " + session.getId());
        }
        try {
            String payload = (String)message.getPayload();
            ClientRequest req = (ClientRequest)this.mapper.readValue(payload, ClientRequest.class);
            req.setPayload(payload);
            log.debug("Request: " + req);
            req.setClient(client);
            this.worldManager.dispatch((VREvent)req);
        }
        catch (SessionException e) {
            log.error("Closing session due to fatal error processing message from client " + client.getId() + ":" + (String)message.getPayload(), (Throwable)e);
            client.sendMessage((Object)this.error((Exception)((Object)e)));
            this.close(session);
        }
        catch (Exception e) {
            log.error("Error processing message from client " + client.getId() + ":" + (String)message.getPayload(), (Throwable)e);
            client.sendMessage((Object)this.error(e));
        }
        catch (Throwable t) {
            log.error("FATAL error", t);
        }
    }

    private void close(WebSocketSession session) {
        try {
            session.close();
        }
        catch (IOException ioe) {
            log.error("Unexpected error", (Throwable)ioe);
        }
    }

    private Map<String, String> error(Exception e) {
        HashMap<String, String> ret = new HashMap<String, String>(1);
        ret.put("ERROR", e.toString());
        return ret;
    }

    public void afterConnectionEstablished(WebSocketSession session) {
        try {
            ConcurrentWebSocketSessionDecorator socket = new ConcurrentWebSocketSessionDecorator(session, 1000, 65536);
            Welcome welcome = this.login(socket);
            this.sessions.put(session.getId(), welcome.getClient());
            this.clients.put(welcome.getClient().getId(), welcome.getClient());
            welcome.getClient().sendMessage((Object)welcome);
            log.info("New session: " + session.getId() + " on " + session.getLocalAddress() + " from " + session.getRemoteAddress() + " user " + session.getPrincipal() + " sessions active " + this.sessions.size());
            if (this.pingFuture == null) {
                this.pingFuture = this.pingScheduler.scheduleAtFixedRate((Runnable)this, 10000L, 10000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (SecurityException se) {
            try {
                log.error("Invalid login from session " + session.getId() + "/" + session.getRemoteAddress(), (Throwable)se);
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.mapper.writeValueAsString((Object)this.error((Exception)se))));
                this.close(session);
            }
            catch (IOException e) {
                log.error("Unexpected error ", (Throwable)e);
            }
        }
    }

    protected Welcome login(ConcurrentWebSocketSessionDecorator socket) {
        Welcome welcome = this.worldManager.login(socket);
        return welcome;
    }

    @Override
    public void run() {
        this.sessions.forEach((id, client) -> {
            try {
                client.getSession().sendMessage((WebSocketMessage)new PingMessage());
            }
            catch (IOException e) {
                log.error("Failed pinging " + client.getSession() + " - " + e);
            }
        });
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        Client client = (Client)this.sessions.remove(session.getId());
        if (client != null && client.getId() != null) {
            this.clients.remove(client.getId());
            log.info("Session closed: " + session.getId() + " on " + session.getLocalAddress() + " from " + session.getRemoteAddress() + " user " + session.getPrincipal() + " reason " + status + " remaining sessions " + this.sessions.size());
            this.worldManager.logout(client);
        }
    }

    public Client getClient(Long id) {
        return (Client)this.clients.get(id);
    }

    public void handlePongMessage(WebSocketSession session, PongMessage message) {
    }

    @PreDestroy
    public void cleanup() {
        for (Client client : this.clients.values()) {
            this.worldManager.logout(client);
        }
    }
}

