/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.vrspace.server.config.ServerConfig;
import org.vrspace.server.obj.Client;

public class SessionTracker {
    private ServerConfig config;
    private ArrayBlockingQueue<Long> activeSessions;

    public SessionTracker(ServerConfig config) {
        this.config = config;
        this.setMaxSessions(config.getMaxSessions());
    }

    public void setMaxSessions(int max) {
        if (max == 0) {
            this.activeSessions = null;
        } else if (this.config.getMaxSessions() == 0) {
            this.activeSessions = new ArrayBlockingQueue(max);
        } else {
            ArrayBlockingQueue q = new ArrayBlockingQueue(max);
            if (this.activeSessions != null) {
                this.activeSessions.drainTo(q);
            }
            this.activeSessions = q;
        }
        this.config.setMaxSessions(max);
    }

    public void addSession(Client client) {
        if (this.config.getMaxSessions() > 0) {
            boolean started;
            try {
                started = this.activeSessions.offer(client.getId(), this.config.getSessionStartTimeout(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted waiting to start session for client " + client.getId());
            }
            if (!started) {
                throw new RuntimeException("Failed to start session " + this.config.getMaxSessions() + " in " + this.config.getSessionStartTimeout() + " seconds ");
            }
        }
    }

    public void remove(Client client) {
        if (this.config.getMaxSessions() > 0) {
            try {
                this.activeSessions.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interupted while removing session of " + client.getId());
            }
        }
    }
}

