/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.vrspace.server.core.VRSpaceDB;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;

public class VRSpaceDBImpl
implements VRSpaceDB {
    @Autowired
    Neo4jTemplate template;

    public <T extends Entity> T get(Class<T> cls, Long id) {
        Optional ret = this.findById(cls, id);
        if (ret.isPresent()) {
            return (T)((Entity)ret.get());
        }
        return null;
    }

    public <T extends Entity> Optional<T> findById(Class<T> cls, Long id) {
        return this.template.findById((Object)id, cls);
    }

    public <T extends Client> T getClientByName(String name, Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Empty client name: " + name);
        }
        Optional c = this.template.findOne("MATCH (o:" + cls.getSimpleName() + ") WHERE o.name = $name RETURN o", Collections.singletonMap("name", name), Client.class);
        if (c.isPresent()) {
            return (T)((Client)this.get(cls, ((Client)c.get()).getId()));
        }
        return null;
    }

    public Client getClientByName(String name) {
        return this.getClientByName(name, Client.class);
    }

    public <T extends Entity> void deleteById(Class<T> cls, Long id) {
        this.template.deleteById((Object)id, cls);
    }
}

