/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.ID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public class Remove
implements Command {
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    private List<Map<String, Long>> objects = new ArrayList();
    @JsonIgnore
    private Iterator<Map<String, Long>> iterator;

    public Remove(VRObject obj) {
        this.removeObject(obj);
    }

    public Remove(String className, Long id) {
        this.objects.add(new ID(className, id).map());
    }

    public Remove(ID ... ids) {
        for (ID id : ids) {
            this.objects.add(id.map());
        }
    }

    public Remove(List<Map<String, Long>> objects) {
        this.objects = objects;
    }

    public Remove removeObject(VRObject obj) {
        this.objects.add(new ID((Entity)obj).map());
        return this;
    }

    public Remove remove(String className, Long id) {
        this.objects.add(new ID(className, id).map());
        return this;
    }

    public ClientResponse execute(WorldManager world, Client client) {
        ArrayList removing = new ArrayList();
        this.objects.forEach(o -> o.forEach((cls, id) -> {
            ID objId = new ID(cls, id);
            VRObject obj = client.getScene().get(objId);
            if (obj != null) {
                removing.add(obj);
                world.remove(client, obj);
            }
        }));
        client.getScene().unpublish(removing);
        return null;
    }

    public ID next() {
        ID ret = null;
        if (this.iterator == null) {
            this.iterator = this.objects.iterator();
        }
        if (this.iterator.hasNext()) {
            ret = new ID((Map)this.iterator.next());
        }
        return ret;
    }

    @Generated
    public List<Map<String, Long>> getObjects() {
        return this.objects;
    }

    @Generated
    public Iterator<Map<String, Long>> getIterator() {
        return this.iterator;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated
    public void setObjects(List<Map<String, Long>> objects) {
        this.objects = objects;
    }

    @JsonIgnore
    @Generated
    public void setIterator(Iterator<Map<String, Long>> iterator) {
        this.iterator = iterator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Remove)) {
            return false;
        }
        Remove other = (Remove)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$objects = this.getObjects();
        List other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects)) {
            return false;
        }
        Iterator this$iterator = this.getIterator();
        Iterator other$iterator = other.getIterator();
        return !(this$iterator == null ? other$iterator != null : !this$iterator.equals(other$iterator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Remove;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        Iterator $iterator = this.getIterator();
        result = result * 59 + ($iterator == null ? 43 : $iterator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Remove(objects=" + this.getObjects() + ", iterator=" + this.getIterator() + ")";
    }

    @Generated
    public Remove() {
    }
}

