/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.vrspace.server.obj.Bot;
import org.vrspace.server.obj.BotLibre;
import org.vrspace.server.obj.Client;

@Node
public class BotLibre
extends Bot {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BotLibre.class);
    @JsonIgnore
    @Transient
    private RestTemplate restTemplate = new RestTemplate();

    public void selfTest() throws Exception {
        ResponseEntity result = this.sendQuery(new Client(), "hello world");
        if (result.getStatusCodeValue() != 200) {
            throw new IllegalStateException("Invalid response code: " + result.getStatusCodeValue());
        }
        String response = (String)result.getBody();
        log.debug(this + " initial response: " + response);
        List contentType = result.getHeaders().get((Object)"Content-Type");
        if (contentType.size() == 0) {
            throw new IllegalStateException("Invalid response - no content type");
        }
        if (contentType.size() == 1) {
            String cType = (String)contentType.get(0);
            log.debug("Response content type: " + cType);
            if (!"application/json".equals(cType)) {
                throw new IllegalStateException("Invalid response content type: " + contentType);
            }
        } else {
            throw new IllegalStateException("Invalid response content type - size " + contentType.size() + " " + contentType);
        }
        log.debug(this.getResponse(new Client(), "hello again"));
    }

    public String getResponse(Client client, String message) {
        String ret = "";
        try {
            ResponseEntity result = this.sendQuery(client, message);
            Response response = (Response)this.getMapper().readValue((String)result.getBody(), Response.class);
            ret = response.getMessage();
            String conversationId = response.getConversation();
            client.setToken(this.serviceId(), conversationId);
        }
        catch (Exception e) {
            log.error("Can't get response to: " + message, (Throwable)e);
        }
        return ret;
    }

    private ResponseEntity<String> sendQuery(Client client, String message) throws Exception {
        Query q = new Query();
        q.setApplication(this.getParameter("application"));
        q.setInstance(this.getParameter("instance"));
        q.setConversation(client.getToken(this.serviceId()));
        q.setMessage(message);
        log.debug(this + " request: " + q);
        URI uri = new URI(this.getUrl());
        String body = this.getMapper().writeValueAsString((Object)q);
        RequestEntity requestEntity = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)body);
        ResponseEntity result = this.restTemplate.exchange(requestEntity, String.class);
        log.debug(this + " response: " + (String)result.getBody());
        return result;
    }

    private String serviceId() {
        return this.getObjectId().toString();
    }

    @Generated
    public BotLibre() {
    }

    @Generated
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @JsonIgnore
    @Generated
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotLibre)) {
            return false;
        }
        BotLibre other = (BotLibre)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BotLibre;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public String toString() {
        return "BotLibre(super=" + super.toString() + ")";
    }
}

