/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.vrspace.server.dto.Add;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.Remove;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.Entity;
import org.vrspace.server.obj.VRObject;

@Node
public class PersistentEvent
extends Entity {
    private long delay;
    private String type;
    private VRObject source;
    @Transient
    private transient Map<String, Object> changes;
    private String payload;
    private List<VRObject> add;
    private List<Map<String, Long>> remove;

    public PersistentEvent() {
    }

    private PersistentEvent(long delay, String type) {
        this.delay = delay;
        this.type = type;
    }

    public PersistentEvent(long delay, String type, VREvent event, VRObject source) {
        this(delay, type);
        this.changes = event.getChanges();
        this.payload = event.getPayload();
        if (this.payload == null) {
            throw new IllegalArgumentException("Event can't be persisted, payload is null");
        }
        this.source = source;
    }

    public PersistentEvent(long delay, String type, Command cmd) {
        this(delay, type);
        if (cmd instanceof Add) {
            this.add = ((Add)cmd).getObjects();
        } else if (cmd instanceof Remove) {
            this.remove = ((Remove)cmd).getObjects();
        } else {
            throw new IllegalArgumentException("Unsupported Command: " + cmd);
        }
    }

    public VREvent getEvent() {
        VREvent ret = new VREvent(this.source);
        ret.setPayload(null);
        ret.setChanges(this.changes);
        return ret;
    }

    public Object getMessage() {
        if (this.add != null) {
            return new Add((Collection)this.add);
        }
        if (this.remove != null) {
            return new Remove(this.remove);
        }
        return this.getEvent();
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public VRObject getSource() {
        return this.source;
    }

    @Generated
    public Map<String, Object> getChanges() {
        return this.changes;
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public List<VRObject> getAdd() {
        return this.add;
    }

    @Generated
    public List<Map<String, Long>> getRemove() {
        return this.remove;
    }

    @Generated
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSource(VRObject source) {
        this.source = source;
    }

    @Generated
    public void setChanges(Map<String, Object> changes) {
        this.changes = changes;
    }

    @Generated
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Generated
    public void setAdd(List<VRObject> add) {
        this.add = add;
    }

    @Generated
    public void setRemove(List<Map<String, Long>> remove) {
        this.remove = remove;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistentEvent)) {
            return false;
        }
        PersistentEvent other = (PersistentEvent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PersistentEvent;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public String toString() {
        return "PersistentEvent(delay=" + this.getDelay() + ", type=" + this.getType() + ", source=" + this.getSource() + ", changes=" + this.getChanges() + ", payload=" + this.getPayload() + ", add=" + this.getAdd() + ", remove=" + this.getRemove() + ")";
    }
}

