/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import lombok.Generated;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.vrspace.server.core.Scene;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.Quaternion;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.Filter;
import org.vrspace.server.types.Owned;

@Node
@Owned
public class User
extends Client {
    private boolean isHumanoid = true;
    @Transient
    private transient Point leftArmPos;
    @Transient
    private transient Point rightArmPos;
    @Transient
    private transient Quaternion leftArmRot;
    @Transient
    private transient Quaternion rightArmRot;

    public User(String name) {
        super(name);
    }

    public void createScene(WorldManager wm) {
        Scene scene = new Scene(wm, (Client)this);
        scene.addFilter("removeOfflineClients", Filter.removeOfflineClients());
        this.setScene(scene);
        scene.update();
        scene.publish((VRObject)this);
    }

    @Generated
    public boolean isHumanoid() {
        return this.isHumanoid;
    }

    @Generated
    public Point getLeftArmPos() {
        return this.leftArmPos;
    }

    @Generated
    public Point getRightArmPos() {
        return this.rightArmPos;
    }

    @Generated
    public Quaternion getLeftArmRot() {
        return this.leftArmRot;
    }

    @Generated
    public Quaternion getRightArmRot() {
        return this.rightArmRot;
    }

    @Generated
    public void setHumanoid(boolean isHumanoid) {
        this.isHumanoid = isHumanoid;
    }

    @Generated
    public void setLeftArmPos(Point leftArmPos) {
        this.leftArmPos = leftArmPos;
    }

    @Generated
    public void setRightArmPos(Point rightArmPos) {
        this.rightArmPos = rightArmPos;
    }

    @Generated
    public void setLeftArmRot(Quaternion leftArmRot) {
        this.leftArmRot = leftArmRot;
    }

    @Generated
    public void setRightArmRot(Quaternion rightArmRot) {
        this.rightArmRot = rightArmRot;
    }

    @Generated
    public User() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public String toString() {
        return "User(super=" + super.toString() + ")";
    }
}

