/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.ApiException;
import org.vrspace.server.config.SeleniumConfig;
import org.vrspace.server.config.ServerConfig;

@RestController
@RequestMapping(value={"/vrspace/api/webbrowser"})
@ConditionalOnProperty(prefix="org.vrspace.server", name={"selenium-enabled"}, havingValue="true")
public class SeleniumController
extends ApiBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SeleniumController.class);
    public static final String PATH = "/vrspace/api/webbrowser";
    @Autowired
    SeleniumConfig.WebSessionFactory factory;
    @Autowired
    ServerConfig config;

    @GetMapping(value={"/available"})
    public boolean available(HttpSession session) {
        return this.config.isSeleniumEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/get"}, produces={"image/png"})
    @ResponseBody
    @ApiResponses(value={@ApiResponse(responseCode="200", headers={@Header(name="history-position", description="Current position in browser window history: 1"), @Header(name="history-length", description="Total length of browser window history: 1")})})
    public ResponseEntity<byte[]> get(String url, HttpSession session) {
        SeleniumConfig.WebSession webSession;
        log.debug("Browser getting " + url);
        SeleniumConfig.WebSession webSession2 = webSession = this.session(session);
        synchronized (webSession2) {
            webSession.webDriver.get(url);
            return new ResponseEntity((Object)this.screenshot(webSession.webDriver), (MultiValueMap)this.makeHeaders(webSession), HttpStatus.OK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/click"}, produces={"image/png"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Clicked, returns screenshot", headers={@Header(name="browser-windows", description="Number of open browser windows/tabs"), @Header(name="clicked-element", description="Tag of the element clicked on"), @Header(name="active-element", description="Tag of the active element after performing the click"), @Header(name="history-position", description="Current position in browser window history"), @Header(name="history-length", description="Total length of browser window history")})})
    @ResponseBody
    public ResponseEntity<byte[]> click(int x, int y, HttpSession session) {
        SeleniumConfig.WebSession webSession;
        log.debug("click:" + x + "," + y);
        SeleniumConfig.WebSession webSession2 = webSession = this.session(session);
        synchronized (webSession2) {
            int numTabs = webSession.activeTabs();
            JavascriptExecutor jse = (JavascriptExecutor)webSession.webDriver;
            String clickedTag = null;
            String location = (String)jse.executeScript("return window.location.href", new Object[0]);
            WebElement clickedElement = webSession.click(x, y);
            if (clickedElement != null && clickedElement.isEnabled()) {
                clickedTag = clickedElement.getTagName();
            }
            this.wait(webSession.webDriver);
            if (numTabs < webSession.activeTabs()) {
                log.debug("new window");
                webSession.switchTab();
            } else if ("a".equals(clickedTag) || "iframe".equals(clickedTag)) {
                webSession.action();
            } else {
                String newLoc;
                log.debug("Action, location: " + location + " -> " + newLoc + " changed " + !location.equals(newLoc = (String)jse.executeScript("return window.location.href", new Object[0])));
                if (!location.equals(newLoc)) {
                    webSession.action();
                }
            }
            HttpHeaders headers = this.makeHeaders(webSession);
            ResponseEntity ret = new ResponseEntity((Object)this.screenshot(webSession.webDriver), (MultiValueMap)headers, HttpStatus.OK);
            WebElement activeElement = webSession.webDriver.switchTo().activeElement();
            log.debug("Clicked element: " + clickedTag);
            log.debug("Active element: " + activeElement.getTagName());
            headers.add("clicked-element", clickedTag);
            headers.add("active-element", activeElement.getTagName());
            return ret;
        }
    }

    private HttpHeaders makeHeaders(SeleniumConfig.WebSession webSession) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("history-position", webSession.status().depth.toString());
        headers.add("history-length", webSession.status().maxDepth.toString());
        headers.add("browser-windows", webSession.size().toString());
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/scroll"}, produces={"image/png"})
    @ResponseBody
    public byte[] scroll(int pixels, HttpSession session) {
        SeleniumConfig.WebSession webSession;
        log.debug("Scroll " + pixels);
        SeleniumConfig.WebSession webSession2 = webSession = this.session(session);
        synchronized (webSession2) {
            JavascriptExecutor jse = (JavascriptExecutor)webSession.webDriver;
            jse.executeScript("window.scrollBy(0," + pixels + ")", new Object[0]);
            return this.screenshot(webSession.webDriver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/close"}, produces={"image/png"})
    @ResponseBody
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Closed a window and switched to previous one, returns screenshot", headers={@Header(name="browser-windows", description="Number of open browser windows/tabs")}), @ApiResponse(responseCode="204", description="Closed last available window, no content")})
    public ResponseEntity<byte[]> close(HttpSession session) {
        SeleniumConfig.WebSession webSession;
        log.debug("Close window");
        SeleniumConfig.WebSession webSession2 = webSession = this.session(session);
        synchronized (webSession2) {
            if (webSession.close() == 0) {
                session.removeAttribute("webDriver");
                ResponseEntity empty = new ResponseEntity(HttpStatus.NO_CONTENT);
                return empty;
            }
            return new ResponseEntity((Object)this.screenshot(webSession.webDriver), (MultiValueMap)this.makeHeaders(webSession), HttpStatus.OK);
        }
    }

    @GetMapping(value={"/quit"})
    public void quit(HttpSession session) {
        SeleniumConfig.WebSession ret = (SeleniumConfig.WebSession)session.getAttribute("webDriver");
        if (ret != null) {
            ret.webDriver.quit();
            session.removeAttribute("webDriver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/back"}, produces={"image/png"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Went back, returns screenshot", headers={@Header(name="browser-windows", description="Number of open browser windows/tabs"), @Header(name="history-position", description="Current position in browser window history"), @Header(name="history-length", description="Total length of browser window history")}), @ApiResponse(responseCode="204", description="Closed last window")})
    @ResponseBody
    public ResponseEntity<byte[]> back(HttpSession session) {
        SeleniumConfig.WebSession webSession;
        log.debug("back");
        SeleniumConfig.WebSession webSession2 = webSession = this.session(session);
        synchronized (webSession2) {
            if (webSession.status().depth > 0) {
                log.debug("navigating back");
                ((JavascriptExecutor)webSession.webDriver).executeScript("history.back()", new Object[0]);
                webSession.back();
            } else if (webSession.activeTabs() > 1) {
                log.debug("Last action, closing window");
                webSession.close();
            } else {
                log.debug("last window, last action");
                webSession.close();
                session.removeAttribute("webDriver");
                ResponseEntity empty = new ResponseEntity(HttpStatus.NO_CONTENT);
                return empty;
            }
            return new ResponseEntity((Object)this.screenshot(webSession.webDriver), (MultiValueMap)this.makeHeaders(webSession), HttpStatus.OK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/forward"}, produces={"image/png"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Went forward, returns screenshot", headers={@Header(name="browser-windows", description="Number of open browser windows/tabs"), @Header(name="history-position", description="Current position in browser window history"), @Header(name="history-length", description="Total length of browser window history")})})
    @ResponseBody
    public ResponseEntity<byte[]> forward(HttpSession session) {
        SeleniumConfig.WebSession webSession;
        log.debug("forward");
        SeleniumConfig.WebSession webSession2 = webSession = this.session(session);
        synchronized (webSession2) {
            if (webSession.status().depth < webSession.status().maxDepth) {
                webSession.action();
            }
            ((JavascriptExecutor)webSession.webDriver).executeScript("history.forward()", new Object[0]);
            return new ResponseEntity((Object)this.screenshot(webSession.webDriver), (MultiValueMap)this.makeHeaders(webSession), HttpStatus.OK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/enter"}, produces={"image/png"})
    @ResponseBody
    public ResponseEntity<byte[]> enter(String text, HttpSession session) {
        SeleniumConfig.WebSession webSession;
        SeleniumConfig.WebSession webSession2 = webSession = this.session(session);
        synchronized (webSession2) {
            JavascriptExecutor jse = (JavascriptExecutor)webSession.webDriver;
            WebElement inputElement = (WebElement)jse.executeScript("return document.elementFromPoint(arguments[0], arguments[1])", new Object[]{webSession.status().x, webSession.status().y});
            inputElement.sendKeys(new CharSequence[]{text});
            inputElement.submit();
            return new ResponseEntity((Object)this.screenshot(webSession.webDriver), (MultiValueMap)this.makeHeaders(webSession), HttpStatus.OK);
        }
    }

    private byte[] screenshot(WebDriver driver) {
        byte[] ret;
        this.wait(driver);
        log.debug("Browser taking screenshot");
        try {
            File scrFile = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            ret = FileUtils.readFileToByteArray((File)scrFile);
        }
        catch (IOException e) {
            throw new ApiException("Can't read screenshot file: " + e);
        }
        return ret;
    }

    private void wait(WebDriver webDriver) {
        WebDriverWait wait = new WebDriverWait(webDriver, Duration.ofSeconds(10L));
        wait.until(driver -> ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete"));
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private SeleniumConfig.WebSession session(HttpSession session) {
        SeleniumConfig.WebSession ret = (SeleniumConfig.WebSession)session.getAttribute("webDriver");
        if (ret == null) {
            ret = this.factory.newSession();
            session.setAttribute("webDriver", (Object)ret);
        }
        return ret;
    }
}

