/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;
import org.vrspace.server.core.ServerSessionManager;
import org.vrspace.server.core.SessionManager;

@Configuration
@EnableWebSocket
public class WebSocketConfig
implements WebSocketConfigurer {
    @Value(value="${org.vrspace.server.socketPath:/vrspace/client}")
    private String clientPath;
    @Value(value="${org.vrspace.server.socketPath:/vrspace/server}")
    private String serverPath;
    @Value(value="${org.vrspace.server.allowedOrigins:*}")
    private String origins;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ServerSessionManager serverSessionManager;

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)this.sessionManager, new String[]{this.clientPath}).setAllowedOrigins(new String[]{this.origins}).addInterceptors(new HandshakeInterceptor[]{new HttpSessionHandshakeInterceptor()});
        registry.addHandler((WebSocketHandler)this.serverSessionManager, new String[]{this.serverPath}).setAllowedOrigins(new String[]{this.origins}).addInterceptors(new HandshakeInterceptor[]{new HttpSessionHandshakeInterceptor()});
    }
}

