/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.ApiException;
import org.vrspace.server.core.ClassUtil;

@RestController
@RequestMapping(value={"/vrspace/api/textures"})
public class TextureController
extends ApiBase {
    private static final Logger log = LoggerFactory.getLogger(TextureController.class);
    public static final String PATH = "/vrspace/api/textures";
    private String contentDir = ClassUtil.projectHomeDirectory() + "/content";

    @GetMapping(value={"/list"})
    public List<String> list() {
        try {
            URI contentUri = new URI("file:" + this.contentDir);
            log.debug("Listing " + String.valueOf(contentUri));
            List<String> ret = Files.find(Paths.get(contentUri), 10, (path, attr) -> attr.isRegularFile(), new FileVisitOption[0]).map(path -> path.toUri().toString()).map(fileName -> fileName.substring(fileName.indexOf("/content"))).filter(fileName -> fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".png")).collect(Collectors.toList());
            return ret;
        }
        catch (Exception e) {
            log.error("Error listing textures", (Throwable)e);
            throw new ApiException("Error listing textures: " + String.valueOf(e));
        }
    }

    @GetMapping(value={"/search"})
    public List<String> search(String pattern) {
        try {
            log.debug("Searching textures for " + pattern);
            return this.list().stream().filter(f -> f.toLowerCase().indexOf(pattern) >= 0).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Error listing textures", (Throwable)e);
            throw new ApiException("Error listing textures: " + String.valueOf(e));
        }
    }
}

