/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@ConditionalOnProperty(value={"org.vrspace.oauth2.enabled"})
@EnableWebSecurity
public class WebSecurityConfig {
    public static final String ENDPOINT = "/vrspace/api/oauth2";

    @Bean
    SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        return (SecurityFilterChain)httpSecurity.csrf(csrf -> {
            HttpSecurityBuilder httpSecurityBuilder = csrf.disable();
        }).authorizeRequests(requests -> {
            ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/vrspace/api/oauth2/login**"})).authenticated();
        }).oauth2Login(login -> {
            OAuth2LoginConfigurer.AuthorizationEndpointConfig authorizationEndpointConfig = login.loginPage("/vrspace/api/oauth2/provider").authorizationEndpoint().baseUri("/vrspace/api/oauth2/authorization");
        }).build();
    }
}

