/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.vrspace.server.config.BotConfig;
import org.vrspace.server.core.SessionException;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.obj.Bot;
import org.vrspace.server.obj.World;

@Component
public class BotManager
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(BotManager.class);
    @Autowired
    BotConfig botConfig;
    @Autowired
    WorldManager worldManager;
    String world = "default";

    private Class<? extends Bot> getBotClass(String className) throws Exception {
        if (((String)className).indexOf(46) < 0) {
            className = "org.vrspace.server.obj." + (String)className;
        }
        Class<?> cls = Class.forName((String)className);
        return cls;
    }

    private Bot createBot(String className) throws Exception {
        Class<? extends Bot> cls = this.getBotClass(className);
        Bot instance = cls.getDeclaredConstructor(null).newInstance(new Object[0]);
        log.info("Created new " + className);
        return instance;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        log.info("BotManager starting");
        for (String botId : this.botConfig.getBot().keySet()) {
            Bot bot;
            String botName;
            BotConfig.BotProperties props;
            block12: {
                props = this.botConfig.getBot().get(botId);
                log.info("Intializing bot " + botId + " = " + String.valueOf(props));
                botName = botId;
                if (!StringUtils.isEmpty((CharSequence)props.getName())) {
                    botName = props.getName();
                }
                bot = null;
                try {
                    bot = this.worldManager.getClientByName(botName, this.getBotClass(props.getType()));
                    if (bot != null) break block12;
                    bot = this.createBot(props.getType());
                }
                catch (Exception e) {
                    log.error("Can't load or create bot of type " + props.getType(), (Throwable)e);
                    continue;
                }
            }
            bot.setName(botName);
            bot.setUrl(props.getUrl());
            bot.setMesh(props.getMesh());
            log.debug(botName + " parameter map: " + String.valueOf(props.getParameterMap()));
            bot.setParameterMap(props.getParameterMap());
            if (props.getWorld() != null) {
                World world = this.worldManager.getOrCreateWorld(props.getWorld());
                bot.setWorldId(world.getId());
            }
            if (props.hasPoint(props.getPosition())) {
                bot.setPosition(props.getPoint(props.getPosition()));
            }
            if (props.hasPoint(props.getRotation())) {
                bot.setRotation(props.getRotation(props.getRotation()));
            }
            if (props.hasPoint(props.getScale())) {
                bot.setScale(props.getPoint(props.getScale()));
            }
            this.worldManager.login(bot);
            try {
                this.worldManager.startSession(bot);
            }
            catch (SessionException e) {
                log.error(String.valueOf(bot) + " cannot start session ", (Throwable)e);
                continue;
            }
            try {
                bot.selfTest();
            }
            catch (Exception e) {
                log.error(String.valueOf(bot) + " failed to initialize, disabled", (Throwable)e);
                bot.setActive(false);
                continue;
            }
            log.info("Intialized " + String.valueOf(bot));
        }
    }
}

